from header_common import *
from header_operations import *
from header_triggers import *
from header_scenes import *
from module_constants import *

####################################################################################################################
#  Each scene record contains the following fields:
#  1) Scene id {string}: used for referencing scenes in other files. The prefix scn_ is automatically added before each scene-id.
#  2) Scene flags {int}. See header_scenes.py for a list of available flags
#  3) Mesh name {string}: This is used for indoor scenes only. Use the keyword "none" for outdoor scenes.
#  4) Body name {string}: This is used for indoor scenes only. Use the keyword "none" for outdoor scenes.
#  5) Min-pos {(float,float)}: minimum (x,y) coordinate. Player can't move beyond this limit.
#  6) Max-pos {(float,float)}: maximum (x,y) coordinate. Player can't move beyond this limit.
#  7) Water-level {float}. 
#  8) Terrain code {string}: You can obtain the terrain code by copying it from the terrain generator screen
#  9) List of other scenes accessible from this scene {list of strings}.
#     (deprecated. This will probably be removed in future versions of the module system)
#     (In the new system passages are used to travel between scenes and
#     the passage's variation-no is used to select the game menu item that the passage leads to.)
# 10) List of chest-troops used in this scene {list of strings}. You can access chests by placing them in edit mode.
#     The chest's variation-no is used with this list for selecting which troop's inventory it will access.
#  town_1   Sargoth     #plain
#  town_2   Tihr        #steppe
#  town_3   Veluca      #steppe
#  town_4   Suno        #plain
#  town_5   Jelkala     #plain
#  town_6   Praven      #plain
#  town_7   Uxkhal      #plain
#  town_8   Reyvadin    #plain
#  town_9   Khudan      #snow
#  town_10  Tulga       #steppe
#  town_11  Curaw       #snow
#  town_12  Wercheg     #plain
#  town_13  Rivacheg    #plain
#  town_14  Halmar      #steppe
#  town_15  Yalen
#  town_16  Dhirim
#  town_17  Ichamur
#  town_18  Narra
#  town_19  Shariz
#  town_20  Durquba
#  town_21  Ahmerrad
#  town_22  Bariyye
####################################################################################################################

scenes = [
  ("random_scene",sf_generate|sf_randomize|sf_auto_entry_points,"none", "none", (0,0),(240,240),-0.5,"0x300028000003e8fa0000034e00004b34000059be",
    [],[]),
  ("conversation_scene",sf_generate,"none", "none", (0,0),(240,240),-0.5,"0x00000000200005000002a8ac000003fe0000430c000011bb",
    [],[],"mod_outer_terrain_earth_a2"),
  ("water",sf_generate, "none", "none", (0, 0), (1000, 1000), 0, "0x0000000750000500000d23480000755b0000589b000048c6",
    [],[]),	
	
  ("random_scene_steppe",sf_generate|sf_auto_entry_points,"none", "none", (0,0),(240, 240), 0, "0x0000000151400532000a729c0000b1070000292000007ff7",
    [],[], "mod_outer_terrain_steppe_a2"),
  ("random_scene_plain",sf_generate|sf_auto_entry_points,"none", "none", (0,0),(240, 240), 0, "0x0000000151400532000a729c0000b1070000292000007ff7",
    [],[], "mod_outer_terrain_steppe_a2"),
#playa
#    ("playa1",sf_generate,"none", "none", (0,0),(240,240),-0.5,"0x000000005000050000061d920000720e00005fe3000043f8",
#    [],[],"outer_terrain_playa5"),
#    ("playa2",sf_generate,"none", "none", (0,0),(240,240),-0.5,"0x000000005000050000061d920000720e00005fe3000043f8",
#    [],[],"outer_terrain_playa5"),
   # ("playa3",sf_generate,"none", "none", (0,0),(240,240),-0.5,"0x000000005000050000061d920000720e00005fe3000043f8",
   # [],[],"outer_terrain_playa5"),	
   
  ("random_scene_snow",sf_generate|sf_auto_entry_points,"none", "none", (0,0),(240, 240), 0, "0x0000000151400532000a729c0000b1070000292000007ff7",
    [],[], "mod_outer_terrain_steppe_a2"),
  ("random_scene_desert",sf_generate|sf_auto_entry_points,"none", "none", (0,0),(240, 240), 0, "0x0000000151400532000a729c0000b1070000292000007ff7",
    [],[], "mod_outer_terrain_steppe_a2"),
  ("random_scene_steppe_forest",sf_generate|sf_auto_entry_points,"none", "none", (0,0),(240, 240), 0, "0x0000000151400532000a729c0000b1070000292000007ff7",
    [],[], "mod_outer_terrain_steppe_a2"),
  ("random_scene_plain_forest",sf_generate|sf_auto_entry_points,"none", "none", (0,0),(240, 240), 0, "0x0000000151400532000a729c0000b1070000292000007ff7",
    [],[], "mod_outer_terrain_steppe_a2"),
	
#mar
  ("mar_1",sf_generate|sf_muddy_water|sf_no_horses,"none", "none", (0,0),(240,240),-0.5,"0x000000005000050000061d920000720e00005fe3000043f8",
    [],[],"opensea_crusader_border_3"),
  ("mar_2",sf_generate|sf_muddy_water|sf_no_horses,"none", "none", (0,0),(240,240),-0.5,"0x000000005000050000061d920000720e00005fe3000043f8",
    [],[],"opensea_crusader_border_3"),
  ("mar_3",sf_generate|sf_muddy_water|sf_no_horses,"none", "none", (0,0),(240,240),-0.5,"0x000000005000050000061d920000720e00005fe3000043f8",
    [],[],"opensea_crusader_border_3"),
  ("mar_4",sf_generate|sf_muddy_water|sf_no_horses,"none", "none", (0,0),(240,240),-0.5,"0x000000005000050000061d920000720e00005fe3000043f8",
    [],[],"opensea_crusader_border_3"),
  ("mar_5",sf_generate|sf_muddy_water|sf_no_horses,"none", "none", (0,0),(240,240),-0.5,"0x000000005000050000061d920000720e00005fe3000043f8",
    [],[],"opensea_crusader_border_3"),

#mar	
  ("random_scene_snow_forest",sf_generate|sf_auto_entry_points,"none", "none", (0,0),(240, 240), 0, "0x0000000151400532000a729c0000b1070000292000007ff7",
    [],[], "mod_outer_terrain_steppe_a2"),
  ("random_scene_desert_forest",sf_generate|sf_auto_entry_points,"none", "none", (0,0),(240, 240), 0, "0x0000000151400532000a729c0000b1070000292000007ff7",
    [],[], "mod_outer_terrain_steppe_a2"),
  ("camp_scene",sf_generate|sf_auto_entry_points,"none", "none", (0,0),(240,240),-0.5,"0x300028000003e8fa0000034e00004b34000059be",
    [],[], "mod_outer_terrain_steppe_a2"),
  ("camp_scene_horse_track",sf_generate|sf_auto_entry_points,"none", "none", (0,0),(240,240),-0.5,"0x300028000003e8fa0000034e00004b34000059be",
    [],[], "mod_outer_terrain_steppe_a2"),
  ("four_ways_inn",sf_generate,"none", "none", (0,0),(120,120),-100,"0x0000000030015f2b000350d4000011a4000017ee000054af",
    [],[], "mod_outer_terrain_steppe_a2"),
  ("test_scene",sf_generate,"none", "none", (0,0),(120,120),-100,"0x0230817a00028ca300007f4a0000479400161992",
    [],[], "mod_outer_terrain_steppe_a2"),
  ("quick_battle_1",sf_generate, "none", "none", (0, 0), (120, 120), -100, "0x00000002500005000005d176000076f50000729d000013cf", 
    [],[], "mod_outer_terrain_forest_a2"),
  ("quick_battle_2",sf_generate, "none", "none", (0, 0), (120, 120), -100, "0x0000000050000500000649920000556d0000323c00003a1d", 
    [],[], "mod_outer_terrain_forest_a2"),
  ("quick_battle_3",sf_generate|sf_muddy_water, "none", "none", (0, 0), (120, 120), -100, "0x000000023002dee300045d1d000001bf0000299a0000638f", 
    [],[], "mod_outer_terrain_forest_a2"),
  ("quick_battle_4",sf_generate,"none", "none", (0,0),(120,120),-100,"0x00001d63c005114300006228000053bf00004eb9", 
    [],[], "mod_outer_terrain_steppe_a2"),
  ("quick_battle_5",sf_generate,"none", "none", (0,0),(120,120),-100,"0x3a078bb2000589630000667200002fb90000179c", 
    [],[], "mod_outer_terrain_steppe_a2"),
  ("quick_battle_6",sf_generate,"none", "none", (0,0),(120,120),-100,"0xa0425ccf0004a92a000063d600005a8a00003d9a", 
    [],[], "mod_outer_terrain_steppe_a2"),
  ("quick_battle_7",sf_generate,"none", "none", (0,0),(100,100),-100,"0x314d060900036cd70000295300002ec9000025f3",
    [],[],"mod_outer_terrain_steppe_a2"),
  ("salt_mine",sf_generate,"none", "none", (-200,-200),(200,200),-100,"0x2a07b23200025896000023ee00007f9c000022a8",  
    [],[], "mod_outer_terrain_steppe_a2"),
  ("novice_ground",sf_indoors,"training_house_a", "bo_training_house_a", (-100,-100),(100,100),-100,"0",
    [],[]),
  ("zendar_arena",sf_generate,"none", "none", (0,0),(100,100),-100,"0xa0001d9300031ccb0000156f000048ba0000361c",
    [],[], "mod_outer_terrain_steppe_a2"),
  ("dhorak_keep",sf_generate,"none", "none", (0,0),(120,120),-100,"0x33a7946000028ca300007f4a0000479400161992",
    ["exit"],[]),
  ("reserved4",sf_generate,"none", "none", (0,0),(120,120),-100,"28791",
    [],[]),
  ("reserved5",sf_generate,"none", "none", (0,0),(120,120),-100,"117828",
    [],[]),
  ("reserved6",sf_generate,"none", "none", (0,0),(100,100),-100,"6849",
    [],[]),
  ("reserved7",sf_generate,"none", "none", (0,0),(100,100),-100,"6849",
    [],[]),
  ("reserved8",sf_generate,"none", "none", (0,0),(100,100),-100,"13278",
    [],[]),
  ("reserved9",sf_indoors,"thirsty_lion", "bo_thirsty_lion", (-100,-100),(100,100),-100,"0",
    [],[]),
  ("reserved10",0,"none", "none", (-100,-100),(100,100),-100,"0",
    [],[]),
  ("reserved11",0,"none", "none", (-100,-100),(100,100),-100,"0",
    [],[]),
  ("reserved12",sf_indoors,"thirsty_lion", "bo_thirsty_lion", (-100,-100),(100,100),-100,"0",
    [],[]),
  ("training_ground",sf_generate,"none", "none", (0,0),(120,120),-100,"0x30000500400360d80000189f00002a8380006d91",
    [],["tutorial_chest_1", "tutorial_chest_2"], "outer_terrain_plain_1"),
  ("tutorial_1",sf_indoors,"tutorial_1_scene", "bo_tutorial_1_scene", (-100,-100),(100,100),-100,"0",
    [],[]),
##  ("tutorial_1",sf_generate,"none", "none", (0,0),(120,120),-100,"0x000000003a04ce140005e17a000030030000780e00006979",
##    [],[], "outer_terrain_plain"),
  ("tutorial_2",sf_indoors,"tutorial_2_scene", "bo_tutorial_2_scene", (-100,-100),(100,100),-100,"0",
    [],[]),
  ("tutorial_3",sf_indoors,"tutorial_3_scene", "bo_tutorial_3_scene", (-100,-100),(100,100),-100,"0",
    [],[]),
  ("tutorial_4",sf_generate,"none", "none", (0,0),(120,120),-100,"0x30000500400360d80000189f00002a8380006d91",
    [],[], "mod_outer_terrain_steppe_a2"),
  ("tutorial_5",sf_generate,"none", "none", (0,0),(120,120),-100,"0x3a06dca80005715c0000537400001377000011fe",
    [],[], "mod_outer_terrain_steppe_a2"),


  ("training_ground_horse_track_1",sf_generate,"none", "none", (0,0),(120,120),-100,"0x00000000337553240004d53700000c0500002a0f80006267",
    [],[], "mod_outer_terrain_steppe_a2"),
  ("training_ground_horse_track_2",sf_generate,"none", "none", (0,0),(120,120),-100,"0x00000000301553240004d5370000466000002a0f800073f1",
    [],[], "mod_outer_terrain_steppe_a2"),
  #Kar
  ("training_ground_horse_track_3",sf_generate,"none", "none", (0,0),(120,120),-100,"0x00000000400c12b2000515470000216b0000485e00006928",
    [],[], "mod_outer_terrain_steppe_a2"),
  #Steppe
  ("training_ground_horse_track_4",sf_generate,"none", "none", (0,0),(120,120),-100,"0x00000000200b60320004a5290000180d0000452f00000e90",
    [],[], "mod_outer_terrain_steppe_a2"),
  #Plain
  ("training_ground_horse_track_5",sf_generate,"none", "none", (0,0),(120,120),-100,"0x000000003008208e0006419000000f730000440f00003c86",
    [],[], "mod_outer_terrain_steppe_a2"),

  ("training_ground_ranged_melee_1",sf_generate,"none", "none", (0,0),(120,120),-100,"0x00000001350455c20005194a000041cb00005ae800000ff5",
    [],[], "mod_outer_terrain_steppe_a2"),
  ("training_ground_ranged_melee_2",sf_generate,"none", "none", (0,0),(120,120),-100,"0x0000000532c8dccb0005194a000041cb00005ae800001bdd",
    [],[], "mod_outer_terrain_steppe_a2"),
  #Kar
  ("training_ground_ranged_melee_3",sf_generate,"none", "none", (0,0),(120,120),-100,"0x000000054327dcba0005194a00001b1d00005ae800004d63",
    [],[], "mod_outer_terrain_steppe_a2"),
  #Steppe
  ("training_ground_ranged_melee_4",sf_generate,"none", "none", (0,0),(120,120),-100,"0x000000012247dcba0005194a000041ef00005ae8000050af",
    [],[], "mod_outer_terrain_steppe_a2"),
  #Plain
  ("training_ground_ranged_melee_5",sf_generate,"none", "none", (0,0),(120,120),-100,"0x00000001324a9cba0005194a000041ef00005ae800003c55",
    [],[], "mod_outer_terrain_steppe_a2"),

  ("zendar_center",sf_generate,"none", "none", (0,0),(100,100),-100,"0x300bc5430001e0780000448a0000049f00007932",
    ["the_happy_boar","","zendar_merchant"],[], "mod_outer_terrain_steppe_a2"),
#  ("zendar_center",0,"sargoth_square", "bo_sargoth_square", (-24,-22),(21,13),-100,"0",
#    ["the_happy_boar","","zendar_merchant"],[]),
  ("the_happy_boar",sf_indoors,"interior_town_house_f", "bo_interior_town_house_f", (-100,-100),(100,100),-100,"0",
    ["zendar_center"],["zendar_chest"]),
  ("zendar_merchant",sf_indoors,"interior_town_house_i", "bo_interior_town_house_i", (-100,-100),(100,100),-100,"0",
    [],[]),

# Tvern names:
  #the shy monkey
  #the singing pumpkin
  #three swords
  #red stag
  #the bard's corner


#interior_tavern_a
#  town_1   Sargoth     #plain
#  town_2   Tihr        #plain
#  town_3   Veluca      #steppe
#  town_4   Suno        #plain  
#  town_5   Jelkala     #plain
#  town_6   Praven      #plain
#  town_7   Uxkhal      #plain
#  town_8   Reyvadin    #plain
#  town_9   Khudan      #snow
#  town_10  Tulga       #steppe
#  town_11  Curaw       #snow
#  town_12  Wercheg     #plain
#  town_13  Rivacheg    #plain
#  town_14  Halmar      #steppe
  ("town_1_center",sf_generate|sf_muddy_water,"none", "none", (0,0),(240,240),-0.5,"0x0000000020000500000721e6000011ab000063ff000007ad",
    [],[],"outer_terrain_playa5"),
  ("town_2_center",sf_generate|sf_muddy_water,"none", "none",(0,0),(240,240),-0.5,"0x0000000020000500000721e6000011ab000063ff000007ad",
    [],[],"mod_outer_terrain_earth_a2"),
  ("town_3_center",sf_generate|sf_muddy_water,"none", "none",(0,0),(240,240),-0.5,"0x0000000020000500000721e6000011ab000063ff000007ad",
    [],[],"mod_outer_terrain_earth_a2"),
  ("town_4_center",sf_generate|sf_muddy_water,"none", "none", (0,0),(240,240),-0.5,"0x0000000020000500000721e6000011ab000063ff000007ad",
    [],[],"outer_terrain_playa5"),
  ("town_5_center",sf_generate|sf_muddy_water,"none", "none",(0,0),(240,240),-0.5,"0x0000000020000500000721e6000011ab000063ff000007ad",
    [],[],"mod_outer_terrain_earth_a2"),
  ("town_6_center",sf_generate, "none", "none", (0, 0), (240, 240), -100, "0x0000000650000563000691a4000000000000000000000000",
    [],[],"mod_outer_terrain_jerusalem_1"),
  ("town_7_center",sf_generate|sf_muddy_water,"none", "none",(0,0),(240,240),-0.5,"0x0000000020000500000721e6000011ab000063ff000007ad",
    [],[],"outer_terrain_playa5"),
  ("town_8_center",sf_generate|sf_muddy_water,"none", "none", (0,0),(240,240),-0.5,"0x0000000020000500000721e6000011ab000063ff000007ad",
    [],[],"mod_outer_terrain_earth_a2"),
  ("town_9_center",sf_generate|sf_muddy_water,"none", "none",(0,0),(240,240),-0.5,"0x0000000020000500000721e6000011ab000063ff000007ad",
    [],[],"mod_outer_terrain_earth_a2"),
  ("town_10_center",sf_generate|sf_muddy_water,"none", "none",(0,0),(240,240),-0.5,"0x0000000020000500000721e6000011ab000063ff000007ad",
    [],[],"mod_outer_terrain_earth_a2"),
  ("town_11_center",sf_generate|sf_muddy_water,"none", "none",(0,0),(240,240),-0.5,"0x0000000020000500000721e6000011ab000063ff000007ad",
    [],[],"outer_terrain_playa5"),
  ("town_12_center",sf_generate|sf_muddy_water,"none", "none",(0,0),(240,240),-0.5,"0x0000000020000500000721e6000011ab000063ff000007ad",
    [],[],"outer_terrain_playa5"),
  ("town_13_center",sf_generate|sf_muddy_water,"none", "none",(0,0),(240,240),-0.5,"0x0000000020000500000721e6000011ab000063ff000007ad",
    [],[],"mod_outer_terrain_earth_a2"),
  ("town_14_center",sf_generate|sf_muddy_water,"none", "none",(0,0),(240,240),-0.5,"0x0000000020000500000721e6000011ab000063ff000007ad",
    [],[],"mod_outer_terrain_earth_a2"),
  ("town_15_center",sf_generate|sf_muddy_water,"none", "none",(0,0),(240,240),-0.5,"0x0000000020000500000721e6000011ab000063ff000007ad",
    [],[],"outer_terrain_mallorca"),
  ("town_16_center",sf_generate|sf_muddy_water,"none", "none",(0,0),(240,240),-0.5,"0x0000000020000500000721e6000011ab000063ff000007ad",
    [],[],"outer_terrain_mallorca"),
  ("town_17_center",sf_generate|sf_muddy_water,"none", "none",(0,0),(240,240),-0.5,"0x0000000020000500000721e6000011ab000063ff000007ad",
    [],[],"mod_outer_terrain_earth_a2"),
  ("town_18_center",sf_generate|sf_muddy_water,"none", "none",(0,0),(240,240),-0.5,"0x0000000020000500000721e6000011ab000063ff000007ad",
    [],[],"outer_terrain_mallorca"),
  ("town_19_center",sf_generate|sf_muddy_water,"none", "none",(0,0),(240,240),-0.5,"0x0000000020000500000721e6000011ab000063ff000007ad",
    [],[],"mod_outer_terrain_earth_a2"),
  ("town_20_center",sf_generate|sf_muddy_water,"none", "none",(0,0),(240,240),-0.5,"0x0000000020000500000721e6000011ab000063ff000007ad",
    [],[],"mod_outer_terrain_earth_a2"),
  ("town_21_center",sf_generate|sf_muddy_water,"none", "none",(0,0),(240,240),-0.5,"0x0000000020000500000721e6000011ab000063ff000007ad",
    [],[],"mod_outer_terrain_earth_a2"),
  ("town_22_center",sf_generate|sf_muddy_water,"none", "none",(0,0),(240,240),-0.5,"0x0000000020000500000721e6000011ab000063ff000007ad",
    [],[],"mod_outer_terrain_earth_a2"),
  
 
  ("town_1_castle",sf_indoors, "interior_toledo", "bo_interior_castle_l", (-100,-100),(100,100),-100,"0",
    ["exit"],["town_1_seneschal"]),
  ("town_2_castle",sf_indoors, "interior_lisboa", "bo_interior_castle_w", (-100,-100),(100,100),-100,"0",
    ["exit"],["town_2_seneschal"]),
  ("town_3_castle",sf_generate, "none", "none", (-100,-100),(100,100),-100,"0x00000007300005000002308c00004a840000624700004fda",
    ["exit"],["town_3_seneschal"]),
  ("town_4_castle",sf_indoors, "interior_toledo", "bo_interior_castle_l", (-100,-100),(100,100),-100,"0",
    ["exit"],["town_4_seneschal"]),
  ("town_5_castle",sf_generate, "none", "none", (-100,-100),(100,100),-100,"0x0000000030000500000398e800000f9c000023bc0000680a",
    ["exit"],["town_5_seneschal"]),
  ("town_6_castle",sf_generate, "none", "none", (-100,-100),(100,100),-100,"0x0000000030000500000398e800000f9c000023bc0000680a",
    ["exit"],["town_6_seneschal"]),
  ("town_7_castle",sf_indoors, "interior_lisboa", "bo_interior_castle_w", (-100,-100),(100,100),-100,"0",
    ["exit"],["town_7_seneschal"]),
  ("town_8_castle",sf_indoors, "interior_toledo", "bo_interior_castle_l", (-100,-100),(100,100),-100,"0",
    ["exit"],["town_8_seneschal"]),
  ("town_9_castle",sf_indoors, "interior_lisboa", "bo_interior_castle_w", (-100,-100),(100,100),-100,"0",
    ["exit"],["town_9_seneschal"]),
  ("town_10_castle",sf_generate, "none", "none", (-100,-100),(100,100),-100,"0x0000000030000500000398e800000f9c000023bc0000680a",
    ["exit"],["town_10_seneschal"]),
  ("town_11_castle",sf_indoors, "interior_lisboa", "bo_interior_castle_w", (-100,-100),(100,100),-100,"0",
    ["exit"],["town_11_seneschal"]),
  ("town_12_castle",sf_indoors, "interior_lisboa", "bo_interior_castle_w", (-100,-100),(100,100),-100,"0",
    ["exit"],["town_12_seneschal"]),
  ("town_13_castle",sf_generate,"none", "none", (-100,-100),(100,100),-100,"0x00000007300005000002308c00004a840000624700004fda",
    ["exit"],["town_13_seneschal"]),
  ("town_14_castle",sf_generate, "none", "none", (-100,-100),(100,100),-100,"0x00000007300005000002308c00004a840000624700004fda",
    ["exit"],["town_14_seneschal"]),
  ("town_15_castle",sf_generate, "none", "none", (-100,-100),(100,100),-100,"0x00000007300005000002308c00004a840000624700004fda",
    ["exit"],["town_15_seneschal"]),
  ("town_16_castle",sf_indoors, "interior_lisboa", "bo_interior_castle_w", (-100,-100),(100,100),-100,"0",
    ["exit"],["town_16_seneschal"]),
  ("town_17_castle",sf_generate,"none", "none", (-100,-100),(100,100),-100,"0x00000007300005000002308c00004a840000624700004fda",
    ["exit"],["town_17_seneschal"]),
  ("town_18_castle",sf_generate, "none", "none", (-100,-100),(100,100),-100,"0x00000007300005000002308c00004a840000624700004fda",
    ["exit"],["town_18_seneschal"]),
  ("town_19_castle",sf_generate,"none", "none", (-100,-100),(100,100),-100,"0x00000007300005000002308c00004a840000624700004fda",
    ["exit"],["town_19_seneschal"]),
  ("town_20_castle",sf_indoors, "interior_lisboa", "bo_interior_castle_w", (-100,-100),(100,100),-100,"0",
    ["exit"],["town_20_seneschal"]),
  ("town_21_castle",sf_generate, "none", "none", (-100,-100),(100,100),-100,"0x00000007300005000002308c00004a840000624700004fda",
    ["exit"],["town_21_seneschal"]),
  ("town_22_castle",sf_generate, "none", "none", (-100,-100),(100,100),-100,"0x00000007300005000002308c00004a840000624700004fda",
    ["exit"],["town_22_seneschal"]),
  
  ("town_1_tavern",sf_indoors, "interior_town_house_steppe_g", "bo_interior_town_house_steppe_g", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("town_2_tavern",sf_indoors, "interior_town_house_steppe_g", "bo_interior_town_house_steppe_g", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("town_3_tavern",sf_indoors, "interior_town_house_steppe_c", "bo_interior_town_house_steppe_c", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("town_4_tavern",sf_indoors, "interior_town_house_steppe_g", "bo_interior_town_house_steppe_g", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("town_5_tavern",sf_indoors, "interior_town_house_steppe_c", "bo_interior_town_house_steppe_c", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("town_6_tavern",sf_indoors, "interior_town_house_steppe_g", "bo_interior_town_house_steppe_g", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("town_7_tavern",sf_indoors, "interior_town_house_steppe_g", "bo_interior_town_house_steppe_g", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("town_8_tavern",sf_indoors, "interior_town_house_steppe_g", "bo_interior_town_house_steppe_g", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("town_9_tavern",sf_indoors, "interior_town_house_steppe_c", "bo_interior_town_house_steppe_c", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("town_10_tavern",sf_indoors, "interior_town_house_steppe_c", "bo_interior_town_house_steppe_c", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("town_11_tavern",sf_indoors, "interior_town_house_steppe_g", "bo_interior_town_house_steppe_g", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("town_12_tavern",sf_indoors, "interior_town_house_steppe_g", "bo_interior_town_house_steppe_g", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("town_13_tavern",sf_indoors, "interior_town_house_steppe_c", "bo_interior_town_house_steppe_c", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("town_14_tavern",sf_indoors, "interior_town_house_steppe_c", "bo_interior_town_house_steppe_c", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("town_15_tavern",sf_indoors, "interior_town_house_steppe_c", "bo_interior_town_house_steppe_c", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("town_16_tavern",sf_indoors, "interior_town_house_steppe_c", "bo_interior_town_house_steppe_c", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("town_17_tavern",sf_indoors, "interior_town_house_steppe_g", "bo_interior_town_house_steppe_g", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("town_18_tavern",sf_indoors, "interior_town_house_steppe_c", "bo_interior_town_house_steppe_c", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("town_19_tavern",sf_indoors, "interior_town_house_steppe_g", "bo_interior_town_house_steppe_g", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("town_20_tavern",sf_indoors, "interior_town_house_steppe_g", "bo_interior_town_house_steppe_g", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("town_21_tavern",sf_indoors, "interior_town_house_steppe_g", "bo_interior_town_house_steppe_g", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("town_22_tavern",sf_indoors, "interior_town_house_steppe_g", "bo_interior_town_house_steppe_g", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  
  ("town_1_store",sf_indoors, "interior_town_house_steppe_d", "bo_interior_town_house_steppe_d", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("town_2_store",sf_indoors, "interior_town_house_steppe_g", "bo_interior_town_house_steppe_g", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("town_3_store",sf_indoors, "interior_town_house_steppe_d", "bo_interior_town_house_steppe_d", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("town_4_store",sf_indoors, "interior_town_house_steppe_d", "bo_interior_town_house_steppe_d", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("town_5_store",sf_indoors, "interior_town_house_steppe_d", "bo_interior_town_house_steppe_d", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("town_6_store",sf_indoors, "interior_town_house_steppe_d", "bo_interior_town_house_steppe_d", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("town_7_store",sf_indoors, "interior_town_house_steppe_g", "bo_interior_town_house_steppe_g", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("town_8_store",sf_indoors, "interior_town_house_steppe_d", "bo_interior_town_house_steppe_d", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("town_9_store",sf_indoors, "interior_town_house_steppe_d", "bo_interior_town_house_steppe_d", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("town_10_store",sf_indoors, "interior_town_house_steppe_d", "bo_interior_town_house_steppe_d", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("town_11_store",sf_indoors, "interior_town_house_steppe_g", "bo_interior_town_house_steppe_g", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("town_12_store",sf_indoors, "interior_town_house_steppe_g", "bo_interior_town_house_steppe_g", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("town_13_store",sf_indoors, "interior_town_house_steppe_d", "bo_interior_town_house_steppe_d", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("town_14_store",sf_indoors, "interior_town_house_steppe_d", "bo_interior_town_house_steppe_d", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("town_15_store",sf_indoors, "interior_town_house_steppe_d", "bo_interior_town_house_steppe_d", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("town_16_store",sf_indoors, "interior_town_house_steppe_d", "bo_interior_town_house_steppe_d", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("town_17_store",sf_indoors, "interior_town_house_steppe_d", "bo_interior_town_house_steppe_d", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("town_18_store",sf_indoors, "interior_town_house_steppe_d", "bo_interior_town_house_steppe_d", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("town_19_store",sf_indoors, "interior_town_house_steppe_d", "bo_interior_town_house_steppe_d", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("town_20_store",sf_indoors, "interior_town_house_steppe_g", "bo_interior_town_house_steppe_g", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("town_21_store",sf_indoors, "interior_town_house_steppe_g", "bo_interior_town_house_steppe_g", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("town_22_store",sf_indoors, "interior_town_house_steppe_g", "bo_interior_town_house_steppe_g", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  
  ("town_1_arena",sf_generate,"none", "none", (0,0),(240,240),-0.5,"0x00000000200005000005b94200002a27000031a1000044aa",
    [],[],"mod_outer_terrain_earth_a2"),
  ("town_2_arena",sf_generate,"none", "none", (0,0),(100,100),-100,"0x00000000200005000005b94200002a27000031a1000044aa",
    [],[],"mod_outer_terrain_earth_a2"),
  ("town_3_arena",sf_generate,"none", "none", (0,0),(100,100),-100,"0x00000000200005000005b94200002a27000031a1000044aa",
    [],[],"mod_outer_terrain_earth_a2"),
  ("town_4_arena",sf_generate,"none", "none", (0,0),(240,240),-0.5,"0x00000000200005000005b94200002a27000031a1000044aa",
    [],[],"mod_outer_terrain_earth_a2"),
  ("town_5_arena",sf_generate,"none", "none", (0,0),(100,100),-100,"0x00000000200005000005b94200002a27000031a1000044aa",
    [],[],"mod_outer_terrain_earth_a2"),
  ("town_6_arena",sf_generate,"none", "none", (0,0),(100,100),-100,"0x00000000200005000005b94200002a27000031a1000044aa",
    [],[],"mod_outer_terrain_earth_a2"),
  ("town_7_arena",sf_generate,"none", "none", (0,0),(240,240),-0.5,"0x00000000200005000005b94200002a27000031a1000044aa",
    [],[],"mod_outer_terrain_earth_a2"),
  ("town_8_arena",sf_generate,"none", "none", (0,0),(240,240),-0.5,"0x00000000200005000005b94200002a27000031a1000044aa",
    [],[],"mod_outer_terrain_earth_a2"),
  ("town_9_arena",sf_generate,"none", "none", (0,0),(100,100),-100,"0x00000000200005000005b94200002a27000031a1000044aa",
    [],[],"mod_outer_terrain_earth_a2"),
  ("town_10_arena",sf_generate,"none", "none", (0,0),(100,100),-100,"0x00000000200005000005b94200002a27000031a1000044aa",
    [],[],"mod_outer_terrain_earth_a2"),
  ("town_11_arena",sf_generate,"none", "none", (0,0),(240,240),-0.5,"0x00000000200005000005b94200002a27000031a1000044aa",
    [],[],"mod_outer_terrain_earth_a2"),
  ("town_12_arena",sf_generate,"none", "none", (0,0),(100,100),-100,"0x00000000200005000005b94200002a27000031a1000044aa",
    [],[],"mod_outer_terrain_earth_a2"),
  ("town_13_arena",sf_generate,"none", "none", (0,0),(100,100),-100,"0x00000000200005000005b94200002a27000031a1000044aa",
    [],[],"mod_outer_terrain_earth_a2"),
  ("town_14_arena",sf_generate,"none", "none", (0,0),(100,100),-100,"0x00000000200005000005b94200002a27000031a1000044aa",
    [],[],"mod_outer_terrain_earth_a2"),
  ("town_15_arena",sf_generate,"none", "none", (0,0),(100,100),-100,"0x00000000200005000005b94200002a27000031a1000044aa",
    [],[],"mod_outer_terrain_earth_a2"),
  ("town_16_arena",sf_generate,"none", "none", (0,0),(100,100),-100,"0x00000000200005000005b94200002a27000031a1000044aa",
    [],[],"mod_outer_terrain_earth_a2"),
  ("town_17_arena",sf_generate,"none", "none", (0,0),(100,100),-100,"0x00000000200005000005b94200002a27000031a1000044aa",
    [],[],"mod_outer_terrain_earth_a2"),
  ("town_18_arena",sf_generate,"none", "none", (0,0),(100,100),-100,"0x00000000200005000005b94200002a27000031a1000044aa",
    [],[],"mod_outer_terrain_earth_a2"),
  ("town_19_arena",sf_generate,"none", "none", (0,0),(100,100),-100,"0x00000000200005000005b94200002a27000031a1000044aa",
    [],[],"mod_outer_terrain_earth_a2"),
  ("town_20_arena",sf_generate,"none", "none", (0,0),(100,100),-100,"0x00000000200005000005b94200002a27000031a1000044aa",
    [],[],"mod_outer_terrain_earth_a2"),
  ("town_21_arena",sf_generate,"none", "none", (0,0),(100,100),-100,"0x00000000200005000005b94200002a27000031a1000044aa",
    [],[],"mod_outer_terrain_earth_a2"),
  ("town_22_arena",sf_generate,"none", "none", (0,0),(100,100),-100,"0x00000000200005000005b94200002a27000031a1000044aa",
    [],[],"mod_outer_terrain_earth_a2"),
  
  ("town_1_prison",sf_indoors,"interior_prison_h", "bo_interior_prison_h", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("town_2_prison",sf_indoors,"interior_prison_h", "bo_interior_prison_h", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("town_3_prison",sf_indoors,"interior_prison_o", "bo_interior_prison_o", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("town_4_prison",sf_indoors,"interior_prison_h", "bo_interior_prison_h", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("town_5_prison",sf_indoors,"interior_prison_o", "bo_interior_prison_o", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("town_6_prison",sf_indoors,"interior_prison_n", "bo_interior_prison_n", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("town_7_prison",sf_indoors,"interior_prison_h", "bo_interior_prison_h", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("town_8_prison",sf_indoors,"interior_prison_h", "bo_interior_prison_h", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("town_9_prison",sf_indoors,"interior_prison_o", "bo_interior_prison_o", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("town_10_prison",sf_indoors,"interior_prison_o", "bo_interior_prison_o", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("town_11_prison",sf_indoors,"interior_prison_h", "bo_interior_prison_h", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("town_12_prison",sf_indoors,"interior_prison_h", "bo_interior_prison_h", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("town_13_prison",sf_indoors,"interior_prison_o", "bo_interior_prison_o", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("town_14_prison",sf_indoors,"interior_prison_o", "bo_interior_prison_o", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("town_15_prison",sf_indoors,"interior_prison_o", "bo_interior_prison_o", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("town_16_prison",sf_indoors,"interior_prison_o", "bo_interior_prison_o", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("town_17_prison",sf_indoors,"interior_prison_n", "bo_interior_prison_n", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("town_18_prison",sf_indoors,"interior_prison_o", "bo_interior_prison_o", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("town_19_prison",sf_indoors,"interior_prison_n", "bo_interior_prison_n", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("town_20_prison",sf_indoors,"interior_prison_n", "bo_interior_prison_n", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("town_21_prison",sf_indoors,"interior_prison_n", "bo_interior_prison_n", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("town_22_prison",sf_indoors,"interior_prison_n", "bo_interior_prison_n", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  
  ("town_1_walls",sf_generate|sf_muddy_water,"none", "none", (0,0),(100,100),-100,"0x0000000020004500000761df0000521e0000619000007425 ",
    [],[],"outer_terrain_playa5"),
  ("town_2_walls",sf_generate|sf_muddy_water,"none", "none", (0,0),(100,100),-100,"0x0000000020004500000761df0000521e0000619000007425",
    [],[],"mod_outer_terrain_earth_a2"),
  ("town_3_walls",sf_generate|sf_muddy_water,"none", "none", (0,0),(100,100),-100,"0x0000000020004500000761df0000521e0000619000007425",
    [],[],"mod_outer_terrain_earth_a2"),
  ("town_4_walls",sf_generate|sf_muddy_water,"none", "none", (0,0),(100,100),-100,"0x0000000020004500000761df0000521e0000619000007425 ",
    [],[],"outer_terrain_playa5"),
  ("town_5_walls",sf_generate|sf_muddy_water,"none", "none", (0,0),(100,100),-100,"0x0000000020004500000761df0000521e0000619000007425",
    [],[],"mod_outer_terrain_earth_a2"),
  ("town_6_walls",sf_generate, "none", "none", (0, 0), (250, 250), -100, "0x0000000650000563000691a4000000000000000000000000",
    [],[],"mod_outer_terrain_jerusalem_1"),
  ("town_7_walls",sf_generate|sf_muddy_water,"none", "none", (0,0),(100,100),-100,"0x0000000020004500000761df0000521e0000619000007425",
    [],[],"outer_terrain_playa5"),
  ("town_8_walls",sf_generate|sf_muddy_water,"none", "none", (0,0),(100,100),-100,"0x0000000020004500000761df0000521e0000619000007425 ",
    [],[],"mod_outer_terrain_earth_a2"),
  ("town_9_walls",sf_generate|sf_muddy_water,"none", "none", (0,0),(100,100),-100,"0x0000000020004500000761df0000521e0000619000007425",
    [],[],"mod_outer_terrain_earth_a2"),
  ("town_10_walls",sf_generate|sf_muddy_water,"none", "none", (0,0),(100,100),-100,"0x0000000020004500000761df0000521e0000619000007425",
    [],[],"mod_outer_terrain_earth_a2"),
  ("town_11_walls",sf_generate|sf_muddy_water,"none", "none", (0,0),(100,100),-100,"0x0000000020004500000761df0000521e0000619000007425",
    [],[],"outer_terrain_playa5"),
  ("town_12_walls",sf_generate|sf_muddy_water,"none", "none", (0,0),(100,100),-100,"0x0000000020004500000761df0000521e0000619000007425",
    [],[],"outer_terrain_playa5"),
  ("town_13_walls",sf_generate|sf_muddy_water,"none", "none", (0,0),(100,100),-100,"0x0000000020004500000761df0000521e0000619000007425",
    [],[],"mod_outer_terrain_earth_a2"),
  ("town_14_walls",sf_generate|sf_muddy_water,"none", "none", (0,0),(100,100),-100,"0x0000000020004500000761df0000521e0000619000007425",
    [],[],"mod_outer_terrain_earth_a2"),
  ("town_15_walls",sf_generate|sf_muddy_water,"none", "none", (0,0),(100,100),-100,"0x0000000020004500000761df0000521e0000619000007425",
    [],[],"outer_terrain_playa2"),
  ("town_16_walls",sf_generate|sf_muddy_water,"none", "none", (0,0),(100,100),-100,"0x0000000020004500000761df0000521e0000619000007425",
    [],[],"outer_terrain_playa2"),
  ("town_17_walls",sf_generate|sf_muddy_water,"none", "none", (0,0),(100,100),-100,"0x0000000020004500000761df0000521e0000619000007425",
    [],[],"mod_outer_terrain_earth_a2"),
  ("town_18_walls",sf_generate|sf_muddy_water,"none", "none", (0,0),(100,100),-100,"0x0000000020004500000761df0000521e0000619000007425",
    [],[],"outer_terrain_playa2"),
  ("town_19_walls",sf_generate|sf_muddy_water,"none", "none", (0,0),(100,100),-100,"0x0000000020004500000761df0000521e0000619000007425",
    [],[],"mod_outer_terrain_earth_a2"),
  ("town_20_walls",sf_generate|sf_muddy_water,"none", "none", (0,0),(100,100),-100,"0x0000000020004500000761df0000521e0000619000007425",
    [],[],"mod_outer_terrain_earth_a2"),
  ("town_21_walls",sf_generate|sf_muddy_water,"none", "none", (0,0),(100,100),-100,"0x0000000020004500000761df0000521e0000619000007425",
    [],[],"mod_outer_terrain_earth_a2"),
  ("town_22_walls",sf_generate|sf_muddy_water,"none", "none", (0,0),(100,100),-100,"0x0000000020004500000761df0000521e0000619000007425",
    [],[],"mod_outer_terrain_earth_a2"),
  
  ("town_1_alley",sf_generate,"none", "none", (0,0),(100,100),-100,"0x20008a110002589600006af30000356b00002c27",
    [],[],"mod_outer_terrain_earth_a2"),
  ("town_2_alley",sf_generate,"none", "none", (0,0),(100,100),-100,"0x300bc5430001e0780000448a0000049f00007932",
    [],[],"mod_outer_terrain_earth_a2"),
  ("town_3_alley",sf_generate,"none", "none", (0,0),(100,100),-100,"0x0000000420000500000334ce00001d1100003d0600000d27",
    [],[],"mod_outer_terrain_earth_a2"),
  ("town_4_alley",sf_generate,"none", "none", (0,0),(100,100),-100,"0x20008a110002589600006af30000356b00002c27",
    [],[],"mod_outer_terrain_earth_a2"),
  ("town_5_alley",sf_generate,"none", "none", (0,0),(100,100),-100,"0x0000000420000500000334ce00001d1100003d0600000d27",
    [],[],"mod_outer_terrain_earth_a2"),
  ("town_6_alley",sf_generate,"none", "none", (0,0),(100,100),-100,"0x0000000420000500000334ce00001d1100003d0600000d27",
    [],[],"mod_outer_terrain_earth_a2"),
  ("town_7_alley",sf_generate,"none", "none", (0,0),(100,100),-100,"0x20008a110002589600006af30000356b00002c27",
    [],[],"mod_outer_terrain_earth_a2"),
  ("town_8_alley",sf_generate,"none", "none", (0,0),(100,100),-100,"0x300bc5430001e0780000448a0000049f00007932",
    [],[],"mod_outer_terrain_earth_a2"),
  ("town_9_alley",sf_generate,"none", "none", (0,0),(100,100),-100,"0x0000000420000500000334ce00001d1100003d0600000d27",
    [],[],"mod_outer_terrain_earth_a2"),
  ("town_10_alley",sf_generate,"none", "none", (0,0),(100,100),-100,"0x0000000420000500000334ce00001d1100003d0600000d27",
    [],[],"mod_outer_terrain_earth_a2"),
  ("town_11_alley",sf_generate,"none", "none", (0,0),(100,100),-100,"0x20008a110002589600006af30000356b00002c27",
    [],[],"mod_outer_terrain_earth_a2"),
  ("town_12_alley",sf_generate,"none", "none", (0,0),(100,100),-100,"0x20008a110002589600006af30000356b00002c27",
    [],[],"mod_outer_terrain_earth_a2"),
  ("town_13_alley",sf_generate,"none", "none", (0,0),(100,100),-100,"0x0000000420000500000334ce00001d1100003d0600000d27",
    [],[],"mod_outer_terrain_earth_a2"),
  ("town_14_alley",sf_generate,"none", "none", (0,0),(100,100),-100,"0x0000000420000500000334ce00001d1100003d0600000d27",
    [],[],"mod_outer_terrain_earth_a2"),
  ("town_15_alley",sf_generate,"none", "none", (0,0),(100,100),-100,"0x000000025a00723200046d1b00003e0200001476000052ae",
    [],[],"mod_outer_terrain_earth_a2"),
  ("town_16_alley",sf_generate,"none", "none", (0,0),(100,100),-100,"0x000000025a00723200046d1b00003e0200001476000052ae",
    [],[],"mod_outer_terrain_earth_a2"),
  ("town_17_alley",sf_generate,"none", "none", (0,0),(100,100),-100,"0x0000000420000500000334ce00001d1100003d0600000d27",
    [],[],"mod_outer_terrain_earth_a2"),
  ("town_18_alley",sf_generate,"none", "none", (0,0),(100,100),-100,"0x000000025a00723200046d1b00003e0200001476000052ae",
    [],[],"mod_outer_terrain_earth_a2"),
  ("town_19_alley",sf_generate,"none", "none", (0,0),(100,100),-100,"0x0000000420000500000334ce00001d1100003d0600000d27",
    [],[],"mod_outer_terrain_earth_a2"),
  ("town_20_alley",sf_generate,"none", "none", (0,0),(100,100),-100,"0x0000000420000500000334ce00001d1100003d0600000d27",
    [],[],"mod_outer_terrain_earth_a2"),
  ("town_21_alley",sf_generate,"none", "none", (0,0),(100,100),-100,"0x0000000420000500000334ce00001d1100003d0600000d27",
    [],[],"mod_outer_terrain_earth_a2"),
  ("town_22_alley",sf_generate,"none", "none", (0,0),(100,100),-100,"0x0000000420000500000334ce00001d1100003d0600000d27",
    [],[],"mod_outer_terrain_earth_a2"),

#0x30054d228004050000005a768000688400002e3b
#0x30054da28004050000005a76800022aa00002e3b
#Castles:

#       1 Steppe
  ("castle_1_exterior",sf_generate|sf_muddy_water,"none", "none", (0,0),(100,100),-100,"0x0000000020000500000721e6000011ab000063ff000007ad",
    [],[],"mod_outer_terrain_earth_a2"),
  ("castle_1_interior",sf_indoors, "interior_castle_g_square_keep", "bo_interior_castle_g_square_keep", (-100,-100),(100,100),-100,"0",
    ["exit"],["castle_1_seneschal"]),
  ("castle_1_prison",sf_indoors,"interior_prison_o", "bo_interior_prison_o", (-100,-100),(100,100),-100,"0",
    [],[]),
#       2 Plain
  ("castle_2_exterior",sf_generate|sf_muddy_water,"none", "none", (0,0),(240,240),-0.5,"0x00000000200005000005b94200002a27000031a1000044aa",
    [],[],"mod_outer_terrain_earth_a2"),
  ("castle_2_interior",sf_indoors, "arabian_interior_keep_b", "bo_arabian_interior_keep_b", (-100,-100),(100,100),-100,"0",
    ["exit"],["castle_2_seneschal"]),
  ("castle_2_prison",sf_indoors,"interior_prison_n", "bo_interior_prison_n", (-100,-100),(100,100),-100,"0",
    [],[]),
#       3 Plain
  ("castle_3_exterior",sf_generate|sf_muddy_water,"none", "none", (0,0),(240,240),-0.5,"0x0000000030000500000721e6000011ab000063ff000007ad",
    [],[],"mod_outer_terrain_earth_a2"),
  ("castle_3_interior",sf_indoors, "interior_castle_n", "bo_interior_castle_n", (-100,-100),(100,100),-100,"0",
    ["exit"],["castle_3_seneschal"]),
  ("castle_3_prison",sf_indoors,"interior_prison_a", "bo_interior_prison_a", (-100,-100),(100,100),-100,"0",
    [],[]),
#       4 Plain
  ("castle_4_exterior",sf_generate|sf_muddy_water,"none", "none", (0,0),(100,100),-100,"0x00000000200005000005b94200002a27000031a1000044aa",
    [],[], "mod_outer_terrain_earth_a2"),
  ("castle_4_interior",sf_indoors, "Tinterior_castle_a", "bo_interior_castle_n", (-100,-100),(100,100),-100,"0",
    ["exit"],["castle_4_seneschal"]),
  ("castle_4_prison",sf_indoors,"interior_prison_j", "bo_interior_prison_j", (-100,-100),(100,100),-100,"0",
    [],[]),
#       5 Plain
  ("castle_5_exterior",sf_generate|sf_muddy_water,"none", "none", (0,0),(100,100),-100,"0x00000001300659630003c8f300003ca000006a8900003c89",
    [],[],"mod_outer_terrain_earth_a2"),
  ("castle_5_interior",sf_indoors, "interior_castle_n", "bo_interior_castle_n", (-100,-100),(100,100),-100,"0",
    ["exit"],["castle_5_seneschal"]),
  ("castle_5_prison",sf_indoors,"interior_prison_d", "bo_interior_prison_d", (-100,-100),(100,100),-100,"0",
    [],[]),
#       6 Plain
  ("castle_6_exterior",sf_generate|sf_muddy_water,"none", "none", (0,0),(100,100),-100,"0x000000002000050000059d670000359600004ac200003dcf",
    [],[],"mod_outer_terrain_earth_a2"),
  ("castle_6_interior",sf_indoors, "Tinterior_castle_n", "bo_interior_castle_n", (-100,-100),(100,100),-100,"0",
    ["exit"],["castle_6_seneschal"]),
  ("castle_6_prison",sf_indoors,"interior_prison_d", "bo_interior_prison_d", (-100,-100),(100,100),-100,"0",
    [],[]),
#       7 Snow
  ("castle_7_exterior",sf_generate|sf_muddy_water,"none", "none", (0,0),(100,100),-100,"0x0000000020000500000721e6000011ab000063ff000007ad",
    [],[],"mod_outer_terrain_earth_a2"),
  ("castle_7_interior",sf_indoors, "arabian_interior_keep_b", "bo_arabian_interior_keep_b", (-100,-100),(100,100),-100,"0",
    ["exit"],["castle_7_seneschal"]),
  ("castle_7_prison",sf_indoors,"interior_prison_o", "bo_interior_prison_o", (-100,-100),(100,100),-100,"0",
    [],[]),
#       8 Plain
  ("castle_8_exterior",sf_generate|sf_muddy_water,"none", "none", (0,0),(240,240),-0.5,"0x00000000200005000005b94200002a27000031a1000044aa",
    [],[],"mod_outer_terrain_earth_a2"),
  ("castle_8_interior",sf_indoors, "interior_castle_g_square_keep", "bo_interior_castle_g_square_keep", (-100,-100),(100,100),-100,"0",
    ["exit"],["castle_8_seneschal"]),
  ("castle_8_prison",sf_indoors,"interior_prison_n", "bo_interior_prison_n", (-100,-100),(100,100),-100,"0",
    [],[]),
#       9 Steppe
  ("castle_9_exterior",sf_generate|sf_muddy_water,"none", "none", (0,0),(100,100),-100,"0x0000000020000500000721e6000011ab000063ff000007ad",
    [],[],"mod_outer_terrain_earth_a2"),
  ("castle_9_interior",sf_indoors, "interior_castle_g_square_keep", "bo_interior_castle_g_square_keep", (-100,-100),(100,100),-100,"0",
    ["exit"],["castle_9_seneschal"]),
  ("castle_9_prison",sf_indoors,"interior_prison_o", "bo_interior_prison_o", (-100,-100),(100,100),-100,"0",
    [],[]),
#       10 Steppe  
  ("castle_10_exterior",sf_generate|sf_muddy_water,"none", "none", (0,0),(100,100),-100,"0x0000000020000500000721e6000011ab000063ff000007ad",
    [],[],"mod_outer_terrain_earth_a2"),
  ("castle_10_interior",sf_indoors, "Tinterior_castle_a", "bo_interior_castle_n", (-100,-100),(100,100),-100,"0",
    ["exit"],["castle_10_seneschal"]),
  ("castle_10_prison",sf_indoors,"interior_prison_d", "bo_interior_prison_d", (-100,-100),(100,100),-100,"0",
    [],[]),
#       11 Plain
  ("castle_11_exterior",sf_generate|sf_muddy_water,"none", "none", (0,0),(100,100),-100,"0x00000000200005000008ee3d00007f2800006a9100006095",
    [],[],"mod_outer_terrain_earth_a2"),
  ("castle_11_interior",sf_indoors, "Tinterior_castle_a", "bo_interior_castle_n", (-100,-100),(100,100),-100,"0",
    ["exit"],["castle_11_seneschal"]),
  ("castle_11_prison",sf_indoors,"interior_prison_a", "bo_interior_prison_a", (-100,-100),(100,100),-100,"0",
    [],[]),
#       Plain
  ("castle_12_exterior",sf_generate|sf_muddy_water,"none", "none", (0,0),(100,100),-100,"0x000000023007b23200049d2a00003c37000040ef000037cd",
    [],[],"mod_outer_terrain_earth_a2"),
  ("castle_12_interior",sf_indoors, "interior_castle_n", "bo_interior_castle_n", (-100,-100),(100,100),-100,"0",
    ["exit"],["castle_12_seneschal"]),
  ("castle_12_prison",sf_indoors,"interior_prison_d", "bo_interior_prison_d", (-100,-100),(100,100),-100,"0",
    [],[]),
#       Plain
  ("castle_13_exterior",sf_generate|sf_muddy_water,"none", "none", (0,0),(100,100),-100,"0x00000000200005000005b94200002a27000031a1000044aa",
    [],[],"mod_outer_terrain_earth_a2"),
  ("castle_13_interior",sf_indoors, "Tinterior_castle_n", "bo_interior_castle_n", (-100,-100),(100,100),-100,"0",
    ["exit"],["castle_13_seneschal"]),
  ("castle_13_prison",sf_indoors,"interior_prison_a", "bo_interior_prison_a", (-100,-100),(100,100),-100,"0",
    [],[]),
#       Plain
  ("castle_14_exterior",sf_generate|sf_muddy_water,"none", "none", (0,0),(100,100),-100,"0x0000000020000500000721e6000011ab000063ff000007ad",
    [],[],"mod_outer_terrain_earth_a2"),
  ("castle_14_interior",sf_indoors, "arabian_interior_keep_b", "bo_arabian_interior_keep_b", (-100,-100),(100,100),-100,"0",
    ["exit"],["castle_14_seneschal"]),
  ("castle_14_prison",sf_indoors,"interior_prison_o", "bo_interior_prison_o", (-100,-100),(100,100),-100,"0",
    [],[]),
#       Plain
  ("castle_15_exterior",sf_generate|sf_muddy_water,"none", "none", (0,0),(100,100),-100,"0x0000000020000500000721e6000011ab000063ff000007ad",
    [],[],"mod_outer_terrain_earth_a2"),
  ("castle_15_interior",sf_indoors, "arabian_interior_keep_b", "bo_arabian_interior_keep_b", (-100,-100),(100,100),-100,"0",
    ["exit"],["castle_15_seneschal"]),
  ("castle_15_prison",sf_indoors,"interior_prison_o", "bo_interior_prison_o", (-100,-100),(100,100),-100,"0",
    [],[]),
#       Plain
  ("castle_16_exterior",sf_generate|sf_muddy_water,"none", "none", (0,0),(100,100),-100,"0x0000000020000500000721e6000011ab000063ff000007ad",
    [],[],"mod_outer_terrain_earth_a2"),
  ("castle_16_interior",sf_indoors, "arabian_interior_keep_b", "bo_arabian_interior_keep_b", (-100,-100),(100,100),-100,"0",
    ["exit"],["castle_16_seneschal"]),
  ("castle_16_prison",sf_indoors,"interior_prison_n", "bo_interior_prison_n", (-100,-100),(100,100),-100,"0",
    [],[]),
#       Steppe
  ("castle_17_exterior",sf_generate|sf_muddy_water,"none", "none", (0,0),(100,100),-100,"0x0000000020000500000721e6000011ab000063ff000007ad",
    [],[],"mod_outer_terrain_earth_a2"),
  ("castle_17_interior",sf_indoors, "arabian_interior_keep_b", "bo_arabian_interior_keep_b", (-100,-100),(100,100),-100,"0",
    ["exit"],["castle_17_seneschal"]),
  ("castle_17_prison",sf_indoors,"interior_prison_o", "bo_interior_prison_o", (-100,-100),(100,100),-100,"0",
    [],[]),
#      Snow
  ("castle_18_exterior",sf_generate|sf_muddy_water,"none", "none", (0,0),(100,100),-100,"0x0000000020000500000721e6000011ab000063ff000007ad",
    [],[],"mod_outer_terrain_earth_a2"),
  ("castle_18_interior",sf_indoors, "arabian_interior_keep_b", "bo_arabian_interior_keep_b", (-100,-100),(100,100),-100,"0",
    ["exit"],["castle_18_seneschal"]),
  ("castle_18_prison",sf_indoors,"interior_prison_o", "bo_interior_prison_o", (-100,-100),(100,100),-100,"0",
    [],[]),
#       Snow
  ("castle_19_exterior",sf_generate|sf_muddy_water,"none", "none", (0,0),(240,240),-0.5,"0x0000000020000500000699a100001913000052c3000078bf",
    [],[],"mod_outer_terrain_earth_a2"),
  ("castle_19_interior",sf_indoors, "interior_castle_g_square_keep", "bo_interior_castle_g_square_keep", (-100,-100),(100,100),-100,"0",
    ["exit"],["castle_19_seneschal"]),
  ("castle_19_prison",sf_indoors,"interior_prison_n", "bo_interior_prison_n", (-100,-100),(100,100),-100,"0",
    [],[]),
#       Plain
  ("castle_20_exterior",sf_generate|sf_muddy_water,"none", "none", (0,0),(100,100),-100,"0x0000000020000500000721e6000011ab000063ff000007ad",
    [],[],"mod_outer_terrain_earth_a2"),
  ("castle_20_interior",sf_indoors, "interior_castle_g_square_keep", "bo_interior_castle_g_square_keep", (-100,-100),(100,100),-100,"0",
    ["exit"],["castle_20_seneschal"]),
  ("castle_20_prison",sf_indoors,"interior_prison_o", "bo_interior_prison_o", (-100,-100),(100,100),-100,"0",
    [],[]),

  ("castle_21_exterior",sf_generate|sf_muddy_water,"none", "none", (0,0),(240,240),-0.5,"0x00000000200005000005b94200002a27000031a1000044aa",
    [],[],"mod_outer_terrain_earth_a2"),
  ("castle_21_interior",sf_indoors, "arabian_interior_keep_b", "bo_arabian_interior_keep_b", (-100,-100),(100,100),-100,"0",
    ["exit"],["castle_21_seneschal"]),
  ("castle_21_prison",sf_indoors,"interior_prison_o", "bo_interior_prison_o", (-100,-100),(100,100),-100,"0",
    [],[]),

  ("castle_22_exterior",sf_generate|sf_muddy_water,"none", "none", (0,0),(240,240),-0.5,"0x00000000200005000005b94200002a27000031a1000044aa",
    [],[],"mod_outer_terrain_earth_a2"),
  ("castle_22_interior",sf_indoors, "arabian_interior_keep_b", "bo_arabian_interior_keep_b", (-100,-100),(100,100),-100,"0",
    ["exit"],["castle_22_seneschal"]),
  ("castle_22_prison",sf_indoors,"interior_prison_o", "bo_interior_prison_o", (-100,-100),(100,100),-100,"0",
    [],[]),
  
  ("castle_23_exterior",sf_generate|sf_muddy_water,"none", "none", (0,0),(240,240),-0.5,"0x0000000020000500000699a100001913000052c3000078bf",
    [],[],"mod_outer_terrain_earth_a2"),
  ("castle_23_interior",sf_indoors, "Tinterior_castle_a", "bo_interior_castle_n", (-100,-100),(100,100),-100,"0",
    ["exit"],["castle_23_seneschal"]),
  ("castle_23_prison",sf_indoors,"interior_prison_d", "bo_interior_prison_d", (-100,-100),(100,100),-100,"0",
    [],[]),

  ("castle_24_exterior",sf_generate|sf_muddy_water,"none", "none", (0,0),(240,240),-0.5,"0x00000000200005000005b94200002a27000031a1000044aa",
    [],[],"mod_outer_terrain_earth_a2"),
  ("castle_24_interior",sf_indoors, "interior_castle_g_square_keep", "bo_interior_castle_g_square_keep", (-100,-100),(100,100),-100,"0",
    ["exit"],["castle_24_seneschal"]),
  ("castle_24_prison",sf_indoors,"interior_prison_n", "bo_interior_prison_n", (-100,-100),(100,100),-100,"0",
    [],[]),

  ("castle_25_exterior",sf_generate|sf_muddy_water,"none", "none", (0,0),(240,240),-0.5,"0x0000000020000500000699a100001913000052c3000078bf",
    [],[],"mod_outer_terrain_earth_a2"),
  ("castle_25_interior",sf_indoors, "interior_castle_g_square_keep", "bo_interior_castle_g_square_keep", (-100,-100),(100,100),-100,"0",
    ["exit"],["castle_25_seneschal"]),
  ("castle_25_prison",sf_indoors,"interior_prison_n", "bo_interior_prison_n", (-100,-100),(100,100),-100,"0",
    [],[]),

  ("castle_26_exterior",sf_generate|sf_muddy_water,"none", "none", (0,0),(100,100),-100,"0x0000000020000500000721e6000011ab000063ff000007ad",
    [],[],"mod_outer_terrain_earth_a2"),
  ("castle_26_interior",sf_indoors, "interior_castle_g_square_keep", "bo_interior_castle_g_square_keep", (-100,-100),(100,100),-100,"0",
    ["exit"],["castle_26_seneschal"]),
  ("castle_26_prison",sf_indoors,"interior_prison_o", "bo_interior_prison_o", (-100,-100),(100,100),-100,"0",
    [],[]),

  ("castle_27_exterior",sf_generate|sf_muddy_water,"none", "none", (0,0),(240,240),-0.5,"0x00000000200005000005b94200002a27000031a1000044aa",
    [],[],"mod_outer_terrain_earth_a2"),
  ("castle_27_interior",sf_indoors, "Tinterior_castle_n", "bo_interior_castle_n", (-100,-100),(100,100),-100,"0",
    ["exit"],["castle_27_seneschal"]),
  ("castle_27_prison",sf_indoors,"interior_prison_a", "bo_interior_prison_a", (-100,-100),(100,100),-100,"0",
    [],[]),

  ("castle_28_exterior",sf_generate|sf_muddy_water,"none", "none", (0,0),(100,100),-100,"0x0000000020000500000721e6000011ab000063ff000007ad",
    [],[],"mod_outer_terrain_earth_a2"),
  ("castle_28_interior",sf_indoors, "interior_castle_g_square_keep", "bo_interior_castle_g_square_keep", (-100,-100),(100,100),-100,"0",
    ["exit"],["castle_28_seneschal"]),
  ("castle_28_prison",sf_indoors,"interior_prison_o", "bo_interior_prison_o", (-100,-100),(100,100),-100,"0",
    [],[]),

  ("castle_29_exterior",sf_generate|sf_muddy_water,"none", "none", (0,0),(100,100),-100,"0x00000000200005000005b94200002a27000031a1000044aa",
    [],[],"mod_outer_terrain_earth_a2"),
  ("castle_29_interior",sf_indoors, "interior_castle_g_square_keep", "bo_interior_castle_g_square_keep", (-100,-100),(100,100),-100,"0",
    ["exit"],["castle_29_seneschal"]),
  ("castle_29_prison",sf_indoors,"interior_prison_o", "bo_interior_prison_o", (-100,-100),(100,100),-100,"0",
    [],[]),

  ("castle_30_exterior",sf_generate|sf_muddy_water,"none", "none", (0,0),(240,240),-0.5,"0x00000000200005000005b94200002a27000031a1000044aa",
    [],[],"mod_outer_terrain_earth_a2"),
  ("castle_30_interior",sf_indoors, "interior_castle_g_square_keep", "bo_interior_castle_g_square_keep", (-100,-100),(100,100),-100,"0",
    ["exit"],["castle_30_seneschal"]),
  ("castle_30_prison",sf_indoors,"interior_prison_n", "bo_interior_prison_n", (-100,-100),(100,100),-100,"0",
    [],[]),

  ("castle_31_exterior",sf_generate|sf_muddy_water,"none", "none", (0,0),(100,100),-100,"0x00000000200005000005b94200002a27000031a1000044aa",
    [],[],"mod_outer_terrain_earth_a2"),
  ("castle_31_interior",sf_indoors, "interior_castle_g_square_keep", "bo_interior_castle_g_square_keep", (-100,-100),(100,100),-100,"0",
    ["exit"],["castle_31_seneschal"]),
  ("castle_31_prison",sf_indoors,"interior_prison_o", "bo_interior_prison_o", (-100,-100),(100,100),-100,"0",
    [],[]),

  ("castle_32_exterior",sf_generate|sf_muddy_water,"none", "none", (0,0),(100,100),-100,"0x0000000030000500000721e6000011ab000063ff000007ad",
    [],[],"mod_outer_terrain_earth_a2"),
  ("castle_32_interior",sf_indoors, "interior_castle_n", "bo_interior_castle_n", (-100,-100),(100,100),-100,"0",
    ["exit"],["castle_32_seneschal"]),
  ("castle_32_prison",sf_indoors,"interior_prison_a", "bo_interior_prison_a", (-100,-100),(100,100),-100,"0",
    [],[]),

  ("castle_33_exterior",sf_generate|sf_muddy_water,"none", "none", (0,0),(240,240),-0.5,"0x0000000020000500000699a100001913000052c3000078bf",
    [],[],"mod_outer_terrain_earth_a2"),
  ("castle_33_interior",sf_indoors, "interior_castle_g_square_keep", "bo_interior_castle_g_square_keep", (-100,-100),(100,100),-100,"0",
    ["exit"],["castle_33_seneschal"]),
  ("castle_33_prison",sf_indoors,"interior_prison_n", "bo_interior_prison_n", (-100,-100),(100,100),-100,"0",
    [],[]),

  ("castle_34_exterior",sf_generate|sf_muddy_water,"none", "none", (0,0),(240,240),-0.5,"0x00000000200005000005b94200002a27000031a1000044aa",
    [],[],"mod_outer_terrain_earth_a2"),
  ("castle_34_interior",sf_indoors, "Tinterior_castle_n", "bo_interior_castle_n", (-100,-100),(100,100),-100,"0",
    ["exit"],["castle_34_seneschal"]),
  ("castle_34_prison",sf_indoors,"interior_prison_j", "bo_interior_prison_j", (-100,-100),(100,100),-100,"0",
    [],[]),

  ("castle_35_exterior",sf_generate|sf_muddy_water,"none", "none", (0,0),(100,100),-100,"0x0000000020000500000721e6000011ab000063ff000007ad",
    [],[],"mod_outer_terrain_earth_a2"),
  ("castle_35_interior",sf_indoors, "arabian_interior_keep_b", "bo_arabian_interior_keep_b", (-100,-100),(100,100),-100,"0",
    ["exit"],["castle_35_seneschal"]),
  ("castle_35_prison",sf_indoors,"interior_prison_o", "bo_interior_prison_o", (-100,-100),(100,100),-100,"0",
    [],[]),

  ("castle_36_exterior",sf_generate|sf_muddy_water,"none", "none", (0,0),(100,100),-100,"0x000000003009cde1000599630000423b00005756000000af",
    [],[],"mod_outer_terrain_earth_a2"),
  ("castle_36_interior",sf_indoors, "interior_castle_n", "bo_interior_castle_n", (-100,-100),(100,100),-100,"0",
    ["exit"],["castle_36_seneschal"]),
  ("castle_36_prison",sf_indoors,"interior_prison_a", "bo_interior_prison_a", (-100,-100),(100,100),-100,"0",
    [],[]),

  ("castle_37_exterior",sf_generate|sf_muddy_water,"none", "none", (0,0),(100,100),-100,"0x0000000020000500000721e6000011ab000063ff000007ad",
    [],[],"mod_outer_terrain_earth_a2"),
  ("castle_37_interior",sf_indoors, "arabian_interior_keep_b", "bo_arabian_interior_keep_b", (-100,-100),(100,100),-100,"0",
    ["exit"],["castle_37_seneschal"]),
  ("castle_37_prison",sf_indoors,"interior_prison_o", "bo_interior_prison_o", (-100,-100),(100,100),-100,"0",
    [],[]),

  ("castle_38_exterior",sf_generate|sf_muddy_water,"none", "none", (0,0),(100,100),-100,"0x0000000020000500000721e6000011ab000063ff000007ad",
    [],[],"mod_outer_terrain_earth_a2"),
  ("castle_38_interior",sf_indoors, "arabian_interior_keep_b", "bo_arabian_interior_keep_b", (-100,-100),(100,100),-100,"0",
    ["exit"],["castle_38_seneschal"]),
  ("castle_38_prison",sf_indoors,"interior_prison_n", "bo_interior_prison_n", (-100,-100),(100,100),-100,"0",
    [],[]),

  ("castle_39_exterior",sf_generate|sf_muddy_water,"none", "none", (0,0),(100,100),-100,"0x00000000200005000005b94200002a27000031a1000044aa",
    [],[],"mod_outer_terrain_earth_a2"),
  ("castle_39_interior",sf_indoors, "interior_castle_g_square_keep", "bo_interior_castle_g_square_keep", (-100,-100),(100,100),-100,"0",
    ["exit"],["castle_39_seneschal"]),
  ("castle_39_prison",sf_indoors,"interior_prison_o", "bo_interior_prison_o", (-100,-100),(100,100),-100,"0",
    [],[]),

  ("castle_40_exterior",sf_generate|sf_muddy_water,"none", "none", (0,0),(100,100),-100,"0x00000000200005000005b94200002a27000031a1000044aa",
    [],[],"mod_outer_terrain_earth_a2"),
  ("castle_40_interior",sf_indoors, "interior_castle_g_square_keep", "bo_interior_castle_g_square_keep", (-100,-100),(100,100),-100,"0",
    ["exit"],["castle_40_seneschal"]),
  ("castle_40_prison",sf_indoors,"interior_prison_o", "bo_interior_prison_o", (-100,-100),(100,100),-100,"0",
    [],[]),


  ("castle_41_exterior",sf_generate|sf_muddy_water,"none", "none", (0,0),(100,100),-100,"0x0000000020000500000721e6000011ab000063ff000007ad",
    [],[],"mod_outer_terrain_earth_a2"),
  ("castle_41_interior",sf_indoors, "arabian_interior_keep_b", "bo_arabian_interior_keep_b", (-100,-100),(100,100),-100,"0",
    ["exit"],["castle_41_seneschal"]),
  ("castle_41_prison",sf_indoors,"interior_prison_o", "bo_interior_prison_o", (-100,-100),(100,100),-100,"0",
    [],[]),

  ("castle_42_exterior",sf_generate|sf_muddy_water,"none", "none", (0,0),(240,240),-0.5,"0x00000000200005000005b94200002a27000031a1000044aa",
    [],[],"mod_outer_terrain_earth_a2"),
  ("castle_42_interior",sf_indoors, "arabian_interior_keep_b", "bo_arabian_interior_keep_b", (-100,-100),(100,100),-100,"0",
    ["exit"],["castle_42_seneschal"]),
  ("castle_42_prison",sf_indoors,"interior_prison_o", "bo_interior_prison_o", (-100,-100),(100,100),-100,"0",
    [],[]),

  ("castle_43_exterior",sf_generate|sf_muddy_water,"none", "none", (0,0),(100,100),-100,"0x0000000020000500000721e6000011ab000063ff000007ad",
    [],[],"mod_outer_terrain_earth_a2"),
  ("castle_43_interior",sf_indoors, "arabian_interior_keep_b", "bo_arabian_interior_keep_b", (-100,-100),(100,100),-100,"0",
    ["exit"],["castle_43_seneschal"]),
  ("castle_43_prison",sf_indoors,"interior_prison_n", "bo_interior_prison_n", (-100,-100),(100,100),-100,"0",
    [],[]),

  ("castle_44_exterior",sf_generate|sf_muddy_water,"none", "none", (0,0),(100,100),-100,"0x0000000020000500000721e6000011ab000063ff000007ad",
    [],[],"mod_outer_terrain_earth_a2"),
  ("castle_44_interior",sf_indoors, "arabian_interior_keep_b", "bo_arabian_interior_keep_b", (-100,-100),(100,100),-100,"0",
    ["exit"],["castle_44_seneschal"]),
  ("castle_44_prison",sf_indoors,"interior_prison_n", "bo_interior_prison_n", (-100,-100),(100,100),-100,"0",
    [],[]),

  ("castle_45_exterior",sf_generate|sf_muddy_water,"none", "none", (0,0),(100,100),-100,"0x0000000020000500000721e6000011ab000063ff000007ad",
    [],[],"mod_outer_terrain_earth_a2"),
  ("castle_45_interior",sf_indoors, "interior_castle_g_square_keep", "bo_interior_castle_g_square_keep", (-100,-100),(100,100),-100,"0",
    ["exit"],["castle_45_seneschal"]),
  ("castle_45_prison",sf_indoors,"interior_prison_o", "bo_interior_prison_o", (-100,-100),(100,100),-100,"0",
    [],[]),

  ("castle_46_exterior",sf_generate|sf_muddy_water,"none", "none", (0,0),(240,240),-0.5,"0x00000000200005000005b94200002a27000031a1000044aa",
    [],[],"mod_outer_terrain_earth_a2"),
  ("castle_46_interior",sf_indoors, "arabian_interior_keep_b", "bo_arabian_interior_keep_b", (-100,-100),(100,100),-100,"0",
    ["exit"],["castle_46_seneschal"]),
  ("castle_46_prison",sf_indoors,"interior_prison_o", "bo_interior_prison_o", (-100,-100),(100,100),-100,"0",
    [],[]),

  ("castle_47_exterior",sf_generate|sf_muddy_water,"none", "none", (0,0),(240,240),-0.5,"0x00000000200005000005b94200002a27000031a1000044aa",
    [],[],"mod_outer_terrain_earth_a2"),
  ("castle_47_interior",sf_indoors, "arabian_interior_keep_b", "bo_arabian_interior_keep_b", (-100,-100),(100,100),-100,"0",
    ["exit"],["castle_47_seneschal"]),
  ("castle_47_prison",sf_indoors,"interior_prison_n", "bo_interior_prison_n", (-100,-100),(100,100),-100,"0",
    [],[]),

  ("castle_48_exterior",sf_generate|sf_muddy_water,"none", "none", (0,0),(240,240),-0.5,"0x00000000200005000005b94200002a27000031a1000044aa",
    [],[],"mod_outer_terrain_earth_a2"),
  ("castle_48_interior",sf_indoors, "arabian_interior_keep_b", "bo_arabian_interior_keep_b", (-100,-100),(100,100),-100,"0",
    ["exit"],["castle_48_seneschal"]),
  ("castle_48_prison",sf_indoors,"interior_prison_n", "bo_interior_prison_n", (-100,-100),(100,100),-100,"0",
    [],[]),

## CC
  ("castle_49_exterior",sf_generate|sf_muddy_water,"none", "none", (0,0),(100,100),-100,"0x0000000020000500000721e6000011ab000063ff000007ad",
    [],[],"mod_outer_terrain_earth_a2"),
  ("castle_49_interior",sf_indoors, "arabian_interior_keep_b", "bo_arabian_interior_keep_b", (-100,-100),(100,100),-100,"0",
    ["exit"],["castle_49_seneschal"]),
  ("castle_49_prison",sf_indoors,"interior_prison_o", "bo_interior_prison_o", (-100,-100),(100,100),-100,"0",
    [],[]),

  ("castle_50_exterior",sf_generate|sf_muddy_water,"none", "none", (0,0),(100,100),-100,"0x0000000020000500000721e6000011ab000063ff000007ad",
    [],[],"mod_outer_terrain_earth_a2"),
  ("castle_50_interior",sf_indoors, "arabian_interior_keep_b", "bo_arabian_interior_keep_b", (-100,-100),(100,100),-100,"0",
    ["exit"],["castle_50_seneschal"]),
  ("castle_50_prison",sf_indoors,"interior_prison_o", "bo_interior_prison_o", (-100,-100),(100,100),-100,"0",
    [],[]),

  ("castle_51_exterior",sf_generate|sf_muddy_water,"none", "none", (0,0),(100,100),-100,"0x0000000020000500000721e6000011ab000063ff000007ad",
    [],[],"mod_outer_terrain_earth_a2"),
  ("castle_51_interior",sf_indoors, "interior_castle_g_square_keep", "bo_interior_castle_g_square_keep", (-100,-100),(100,100),-100,"0",
    ["exit"],["castle_51_seneschal"]),
  ("castle_51_prison",sf_indoors,"interior_prison_o", "bo_interior_prison_o", (-100,-100),(100,100),-100,"0",
    [],[]),

  ("castle_52_exterior",sf_generate|sf_muddy_water,"none", "none", (0,0),(100,100),-100,"0x0000000020000500000721e6000011ab000063ff000007ad",
    [],[],"mod_outer_terrain_earth_a2"),
  ("castle_52_interior",sf_indoors, "arabian_interior_keep_b", "bo_arabian_interior_keep_b", (-100,-100),(100,100),-100,"0",
    ["exit"],["castle_52_seneschal"]),
  ("castle_52_prison",sf_indoors,"interior_prison_o", "bo_interior_prison_o", (-100,-100),(100,100),-100,"0",
    [],[]),

  ("castle_53_exterior",sf_generate|sf_muddy_water,"none", "none", (0,0),(100,100),-100,"0x0000000020000500000721e6000011ab000063ff000007ad",
    [],[],"mod_outer_terrain_earth_a2"),
  ("castle_53_interior",sf_indoors, "arabian_interior_keep_b", "bo_arabian_interior_keep_b", (-100,-100),(100,100),-100,"0",
    ["exit"],["castle_53_seneschal"]),
  ("castle_53_prison",sf_indoors,"interior_prison_o", "bo_interior_prison_o", (-100,-100),(100,100),-100,"0",
    [],[]),

  ("castle_54_exterior",sf_generate|sf_muddy_water,"none", "none", (0,0),(100,100),-100,"0x000000014004d81100057963000062ce0000255800004c09",
    [],[],"mod_outer_terrain_earth_a2"),
  ("castle_54_interior",sf_indoors, "interior_castle_c", "bo_interior_castle_c", (-100,-100),(100,100),-100,"0",
    ["exit"],["castle_54_seneschal"]),
  ("castle_54_prison",sf_indoors,"interior_prison_e", "bo_interior_prison_e", (-100,-100),(100,100),-100,"0",
    [],[]),

  ("castle_55_exterior",sf_generate|sf_muddy_water,"none", "none", (0,0),(100,100),-100,"0x0000000240079f9e0005695a0000035f00003ef400004aa8",
    [],[],"mod_outer_terrain_earth_a2"),
  ("castle_55_interior",sf_indoors, "interior_castle_n", "bo_interior_castle_n", (-100,-100),(100,100),-100,"0",
    ["exit"],["castle_55_seneschal"]),
  ("castle_55_prison",sf_indoors,"interior_prison_k", "bo_interior_prison_k", (-100,-100),(100,100),-100,"0",
    [],[]),

  ("castle_56_exterior",sf_generate|sf_muddy_water,"none", "none", (0,0),(100,100),-100,"0x0000000220045d9b0005d9760000034a00002a3e00006fbd",
    [],[],"mod_outer_terrain_earth_a2"),
  ("castle_56_interior",sf_indoors, "interior_castle_l", "bo_interior_castle_l", (-100,-100),(100,100),-100,"0",
    ["exit"],["castle_56_seneschal"]),
  ("castle_56_prison",sf_indoors,"interior_prison_a", "bo_interior_prison_a", (-100,-100),(100,100),-100,"0",
    [],[]),
    
  ("castle_57_exterior",sf_generate|sf_muddy_water,"none", "none", (0,0),(100,100),-100,"0x0000000254c2ec0000042509000016da0000017200000ed3",
    [],[],"mod_outer_terrain_earth_a2"),
  ("castle_57_interior",sf_indoors, "arabian_interior_keep_b", "bo_arabian_interior_keep_b", (-100,-100),(100,100),-100,"0",
    ["exit"],["castle_57_seneschal"]),
  ("castle_57_prison",sf_indoors,"interior_prison_n", "bo_interior_prison_n", (-100,-100),(100,100),-100,"0",
    [],[]),

  ("castle_58_exterior",sf_generate|sf_muddy_water,"none", "none", (0,0),(100,100),-100,"0x0000000053e3b2320004ed3800001eb400006277000068ea",
    [],[],"mod_outer_terrain_earth_a2"),
  ("castle_58_interior",sf_indoors, "arabian_interior_keep_b", "bo_arabian_interior_keep_b", (-100,-100),(100,100),-100,"0",
    ["exit"],["castle_58_seneschal"]),
  ("castle_58_prison",sf_indoors,"interior_prison_o", "bo_interior_prison_o", (-100,-100),(100,100),-100,"0",
    [],[]),

  ("castle_59_exterior",sf_generate|sf_muddy_water,"none", "none", (0,0),(100,100),-100,"0x0000000254c2ec0000042509000016da0000017200000ed3",
    [],[],"mod_outer_terrain_earth_a2"),
  ("castle_59_interior",sf_indoors, "arabian_interior_keep_b", "bo_arabian_interior_keep_b", (-100,-100),(100,100),-100,"0",
    ["exit"],["castle_59_seneschal"]),
  ("castle_59_prison",sf_indoors,"interior_prison_n", "bo_interior_prison_n", (-100,-100),(100,100),-100,"0",
    [],[]),

  ("castle_60_exterior",sf_generate|sf_muddy_water,"none", "none", (0,0),(100,100),-100,"0x0000000254c2ec0000042509000016da0000017200000ed3",
    [],[],"mod_outer_terrain_earth_a2"),
  ("castle_60_interior",sf_indoors, "arabian_interior_keep_b", "bo_arabian_interior_keep_b", (-100,-100),(100,100),-100,"0",
    ["exit"],["castle_60_seneschal"]),
  ("castle_60_prison",sf_indoors,"interior_prison_n", "bo_interior_prison_n", (-100,-100),(100,100),-100,"0",
    [],[]),

  ("castle_61_exterior",sf_generate|sf_muddy_water,"none", "none", (0,0),(100,100),-100,"0x0000000254c2ec0000042509000016da0000017200000ed3",
    [],[],"mod_outer_terrain_earth_a2"),
  ("castle_61_interior",sf_indoors, "arabian_interior_keep_b", "bo_arabian_interior_keep_b", (-100,-100),(100,100),-100,"0",
    ["exit"],["castle_61_seneschal"]),
  ("castle_61_prison",sf_indoors,"interior_prison_n", "bo_interior_prison_n", (-100,-100),(100,100),-100,"0",
    [],[]),

  ("castle_62_exterior",sf_generate|sf_muddy_water,"none", "none", (0,0),(100,100),-100,"0x0000000130025cb20006097f00005b1400000e2f00005fd9",
    [],[],"mod_outer_terrain_earth_a2"),
  ("castle_62_interior",sf_indoors, "interior_castle_k", "bo_interior_castle_k", (-100,-100),(100,100),-100,"0",
    ["exit"],["castle_62_seneschal"]),
  ("castle_62_prison",sf_indoors,"interior_prison_l", "bo_interior_prison_l", (-100,-100),(100,100),-100,"0",
    [],[]),

  ("castle_63_exterior",sf_generate|sf_muddy_water,"none", "none", (0,0),(100,100),-100,"0x000000023007941f0005415000007e650000225f00003b3e",
    [],[],"mod_outer_terrain_earth_a2"),
  ("castle_63_interior",sf_indoors, "interior_castle_p", "bo_interior_castle_p", (-100,-100),(100,100),-100,"0",
    ["exit"],["castle_63_seneschal"]),
  ("castle_63_prison",sf_indoors,"interior_prison_a", "bo_interior_prison_a", (-100,-100),(100,100),-100,"0",
    [],[]),

  ("castle_64_exterior",sf_generate|sf_muddy_water,"none", "none", (0,0),(100,100),-100,"0x000000005a07b2320002b8ad000036c80000409d00001987",
    [],[],"mod_outer_terrain_earth_a2"),
  ("castle_64_interior",sf_indoors, "arabian_interior_keep_b", "bo_arabian_interior_keep_b", (-100,-100),(100,100),-100,"0",
    ["exit"],["castle_64_seneschal"]),
  ("castle_64_prison",sf_indoors,"interior_prison_n", "bo_interior_prison_n", (-100,-100),(100,100),-100,"0",
    [],[]),
## CC

#!!Villages !!#
  ("village_1",sf_generate|sf_muddy_water,"none", "none", (0,0),(240,240),-0.5,"0x000000002000050000060d76000061b90000664000003d79",
    [],[],"mod_outer_terrain_earth_a2"),
	("village_2",sf_generate,"none", "none", (0,0),(100,100),-100,"0x00000001500410320005a96800006b5300004edc00000d11",
    [],[],"mod_outer_terrain_steppe_a2"),
	("village_3",sf_generate,"none", "none", (0,0),(100,100),-100,"0x00000001500410320005a96800006b5300004edc00000d11",
    [],[],"mod_outer_terrain_steppe_a2"),
	("village_4",sf_generate,"none", "none", (0,0),(100,100),-100,"0x00000001500410320005a96800006b5300004edc00000d11",
    [],[],"mod_outer_terrain_steppe_a2"),
	("village_5",sf_generate,"none", "none", (0,0),(100,100),-100,"0x00000001500410320005a96800006b5300004edc00000d11",
    [],[],"mod_outer_terrain_steppe_a2"),
	("village_6",sf_generate,"none", "none", (0,0),(100,100),-100,"0x00000001500410320005a96800006b5300004edc00000d11",
    [],[],"mod_outer_terrain_steppe_a2"),
	("village_7",sf_generate,"none", "none", (0,0),(100,100),-100,"0x00000001500410320005a96800006b5300004edc00000d11",
    [],[],"mod_outer_terrain_steppe_a2"),
  ("village_8",sf_generate|sf_muddy_water,"none", "none", (0,0),(240,240),-0.5,"0x000000002000050000059d670000359600004ac200003dcf",
    [],[],"mod_outer_terrain_earth_a2"),
	("village_9",sf_generate,"none", "none", (0,0),(100,100),-100,"0x00000001500410320005a96800006b5300004edc00000d11",
    [],[],"mod_outer_terrain_steppe_a2"),
	("village_10",sf_generate,"none", "none", (0,0),(100,100),-100,"0x00000001500410320005a96800006b5300004edc00000d11",
    [],[],"mod_outer_terrain_steppe_a2"),
  ("village_11",sf_generate|sf_muddy_water,"none", "none", (0,0),(240,240),-0.5,"0x000000002000050000059d670000359600004ac200003dcf",
    [],[],"mod_outer_terrain_earth_a2"),
	("village_12",sf_generate,"none", "none", (0,0),(100,100),-100,"0x00000001500410320005a96800006b5300004edc00000d11",
    [],[],"mod_outer_terrain_steppe_a2"),
	("village_13",sf_generate,"none", "none", (0,0),(100,100),-100,"0x00000001500410320005a96800006b5300004edc00000d11",
    [],[],"mod_outer_terrain_steppe_a2"),
	("village_14",sf_generate,"none", "none", (0,0),(100,100),-100,"0x00000001500410320005a96800006b5300004edc00000d11",
    [],[],"mod_outer_terrain_steppe_a2"),
  ("village_15",sf_generate|sf_muddy_water,"none", "none", (0,0),(240,240),-0.5,"0x000000002000050000059d670000359600004ac200003dcf",
    [],[],"mod_outer_terrain_earth_a2"),
  ("village_16",sf_generate|sf_muddy_water,"none", "none", (0,0),(240,240),-0.5,"0x0000000020000500000721e6000011ab000063ff000007ad",
    [],[],"mod_outer_terrain_earth_a2"),
	("village_17",sf_generate,"none", "none", (0,0),(100,100),-100,"0x00000001500410320005a96800006b5300004edc00000d11",
    [],[],"mod_outer_terrain_steppe_a2"),
	("village_18",sf_generate,"none", "none", (0,0),(100,100),-100,"0x00000001500410320005a96800006b5300004edc00000d11",
    [],[],"mod_outer_terrain_steppe_a2"),
	("village_19",sf_generate,"none", "none", (0,0),(100,100),-100,"0x00000001500410320005a96800006b5300004edc00000d11",
    [],[],"mod_outer_terrain_steppe_a2"),
	("village_20",sf_generate,"none", "none", (0,0),(100,100),-100,"0x00000001500410320005a96800006b5300004edc00000d11",
    [],[],"mod_outer_terrain_steppe_a2"),
  ("village_21",sf_generate|sf_muddy_water,"none", "none", (0,0),(240,240),-0.5,"0x000000002000050000059d670000359600004ac200003dcf",
    [],[],"mod_outer_terrain_earth_a2"),
	("village_22",sf_generate,"none", "none", (0,0),(100,100),-100,"0x00000001500410320005a96800006b5300004edc00000d11",
    [],[],"mod_outer_terrain_steppe_a2"),
	("village_23",sf_generate,"none", "none", (0,0),(100,100),-100,"0x00000001500410320005a96800006b5300004edc00000d11",
    [],[],"mod_outer_terrain_steppe_a2"),
	("village_24",sf_generate,"none", "none", (0,0),(100,100),-100,"0x00000001500410320005a96800006b5300004edc00000d11",
    [],[],"mod_outer_terrain_steppe_a2"),
	("village_25",sf_generate,"none", "none", (0,0),(100,100),-100,"0x00000001500410320005a96800006b5300004edc00000d11",
    [],[],"mod_outer_terrain_steppe_a2"),
	("village_26",sf_generate,"none", "none", (0,0),(100,100),-100,"0x00000001500410320005a96800006b5300004edc00000d11",
    [],[],"mod_outer_terrain_steppe_a2"),
	("village_27",sf_generate,"none", "none", (0,0),(100,100),-100,"0x00000001500410320005a96800006b5300004edc00000d11",
    [],[],"mod_outer_terrain_steppe_a2"),
  ("village_28",sf_generate|sf_muddy_water,"none", "none", (0,0),(240,240),-0.5,"0x000000012002a0b20004992700006e54000007fe00001fd2",
    [],[],"mod_outer_terrain_earth_a2"),
	("village_29",sf_generate,"none", "none", (0,0),(100,100),-100,"0x00000001500410320005a96800006b5300004edc00000d11",
    [],[],"mod_outer_terrain_steppe_a2"),
	("village_30",sf_generate,"none", "none", (0,0),(100,100),-100,"0x00000001500410320005a96800006b5300004edc00000d11",
    [],[],"mod_outer_terrain_steppe_a2"),
	("village_31",sf_generate,"none", "none", (0,0),(100,100),-100,"0x00000001500410320005a96800006b5300004edc00000d11",
    [],[],"mod_outer_terrain_steppe_a2"),
	("village_32",sf_generate|sf_muddy_water,"none", "none", (0,0),(100,100),-100,"0x00000001500410320005a96800006b5300004edc00000d11",
    [],[],"mod_outer_terrain_steppe_a2"),
  ("village_33",sf_generate,"none", "none", (0,0),(100,100),-100,"0x00000001500410320005a96800006b5300004edc00000d11",
    [],[],"mod_outer_terrain_steppe_a2"),
	("village_34",sf_generate,"none", "none", (0,0),(100,100),-100,"0x00000001500410320005a96800006b5300004edc00000d11",
    [],[],"mod_outer_terrain_steppe_a2"),
	("village_35",sf_generate,"none", "none", (0,0),(100,100),-100,"0x00000001500410320005a96800006b5300004edc00000d11",
    [],[],"mod_outer_terrain_steppe_a2"),
	("village_36",sf_generate,"none", "none", (0,0),(100,100),-100,"0x00000001500410320005a96800006b5300004edc00000d11",
    [],[],"mod_outer_terrain_steppe_a2"),
	("village_37",sf_generate,"none", "none", (0,0),(100,100),-100,"0x00000001500410320005a96800006b5300004edc00000d11",
    [],[],"mod_outer_terrain_steppe_a2"),
	("village_38",sf_generate,"none", "none", (0,0),(100,100),-100,"0x00000001500410320005a96800006b5300004edc00000d11",
    [],[],"mod_outer_terrain_steppe_a2"),
  ("village_39",sf_generate|sf_muddy_water,"none", "none", (0,0),(240,240),-0.5,"0x000000002000050000059d670000359600004ac200003dcf",
    [],[],"mod_outer_terrain_earth_a2"),
	("village_40",sf_generate,"none", "none", (0,0),(100,100),-100,"0x00000001500410320005a96800006b5300004edc00000d11",
    [],[],"mod_outer_terrain_steppe_a2"),

	("village_41",sf_generate,"none", "none", (0,0),(100,100),-100,"0x00000001500410320005a96800006b5300004edc00000d11",
    [],[],"mod_outer_terrain_steppe_a2"),
	("village_42",sf_generate,"none", "none", (0,0),(100,100),-100,"0x00000001500410320005a96800006b5300004edc00000d11",
    [],[],"mod_outer_terrain_steppe_a2"),
	("village_43",sf_generate,"none", "none", (0,0),(100,100),-100,"0x00000001500410320005a96800006b5300004edc00000d11",
    [],[],"mod_outer_terrain_steppe_a2"),
	("village_44",sf_generate,"none", "none", (0,0),(100,100),-100,"0x00000001500410320005a96800006b5300004edc00000d11",
    [],[],"mod_outer_terrain_steppe_a2"),
	("village_45",sf_generate,"none", "none", (0,0),(100,100),-100,"0x00000001500410320005a96800006b5300004edc00000d11",
    [],[],"mod_outer_terrain_steppe_a2"),
	("village_46",sf_generate,"none", "none", (0,0),(100,100),-100,"0x00000001500410320005a96800006b5300004edc00000d11",
    [],[],"mod_outer_terrain_steppe_a2"),
	("village_47",sf_generate,"none", "none", (0,0),(100,100),-100,"0x00000001500410320005a96800006b5300004edc00000d11",
    [],[],"mod_outer_terrain_steppe_a2"),
	("village_48",sf_generate,"none", "none", (0,0),(100,100),-100,"0x00000001500410320005a96800006b5300004edc00000d11",
    [],[],"mod_outer_terrain_steppe_a2"),
	("village_49",sf_generate,"none", "none", (0,0),(100,100),-100,"0x00000001500410320005a96800006b5300004edc00000d11",
    [],[],"mod_outer_terrain_steppe_a2"),
	("village_50",sf_generate,"none", "none", (0,0),(100,100),-100,"0x00000001500410320005a96800006b5300004edc00000d11",
    [],[],"mod_outer_terrain_steppe_a2"),
	("village_51",sf_generate,"none", "none", (0,0),(100,100),-100,"0x00000001500410320005a96800006b5300004edc00000d11",
    [],[],"mod_outer_terrain_steppe_a2"),
	("village_52",sf_generate,"none", "none", (0,0),(100,100),-100,"0x00000001500410320005a96800006b5300004edc00000d11",
    [],[],"mod_outer_terrain_steppe_a2"),
	("village_53",sf_generate,"none", "none", (0,0),(100,100),-100,"0x00000001500410320005a96800006b5300004edc00000d11",
    [],[],"mod_outer_terrain_steppe_a2"),
	("village_54",sf_generate,"none", "none", (0,0),(100,100),-100,"0x00000001500410320005a96800006b5300004edc00000d11",
    [],[],"mod_outer_terrain_steppe_a2"),
	("village_55",sf_generate,"none", "none", (0,0),(100,100),-100,"0x00000001500410320005a96800006b5300004edc00000d11",
    [],[],"mod_outer_terrain_steppe_a2"),
	("village_56",sf_generate,"none", "none", (0,0),(100,100),-100,"0x00000001500410320005a96800006b5300004edc00000d11",
    [],[],"mod_outer_terrain_steppe_a2"),
	("village_57",sf_generate,"none", "none", (0,0),(100,100),-100,"0x00000001500410320005a96800006b5300004edc00000d11",
    [],[],"mod_outer_terrain_steppe_a2"),
	("village_58",sf_generate,"none", "none", (0,0),(100,100),-100,"0x00000001500410320005a96800006b5300004edc00000d11",
    [],[],"mod_outer_terrain_steppe_a2"),
	("village_59",sf_generate,"none", "none", (0,0),(100,100),-100,"0x00000001500410320005a96800006b5300004edc00000d11",
    [],[],"mod_outer_terrain_steppe_a2"),
	("village_60",sf_generate,"none", "none", (0,0),(100,100),-100,"0x00000001500410320005a96800006b5300004edc00000d11",
    [],[],"mod_outer_terrain_steppe_a2"),
	("village_61",sf_generate,"none", "none", (0,0),(100,100),-100,"0x00000001500410320005a96800006b5300004edc00000d11",
    [],[],"mod_outer_terrain_steppe_a2"),
	("village_62",sf_generate,"none", "none", (0,0),(100,100),-100,"0x00000001500410320005a96800006b5300004edc00000d11",
    [],[],"mod_outer_terrain_steppe_a2"),
	("village_63",sf_generate,"none", "none", (0,0),(100,100),-100,"0x00000001500410320005a96800006b5300004edc00000d11",
    [],[],"mod_outer_terrain_steppe_a2"),
	("village_64",sf_generate,"none", "none", (0,0),(100,100),-100,"0x00000001500410320005a96800006b5300004edc00000d11",
    [],[],"mod_outer_terrain_steppe_a2"),
	("village_65",sf_generate,"none", "none", (0,0),(100,100),-100,"0x00000001500410320005a96800006b5300004edc00000d11",
    [],[],"mod_outer_terrain_steppe_a2"),
	("village_66",sf_generate,"none", "none", (0,0),(100,100),-100,"0x00000001500410320005a96800006b5300004edc00000d11",
    [],[],"mod_outer_terrain_steppe_a2"),
	("village_67",sf_generate,"none", "none", (0,0),(100,100),-100,"0x00000001500410320005a96800006b5300004edc00000d11",
    [],[],"mod_outer_terrain_steppe_a2"),
	("village_68",sf_generate,"none", "none", (0,0),(100,100),-100,"0x00000001500410320005a96800006b5300004edc00000d11",
    [],[],"mod_outer_terrain_steppe_a2"),
	("village_69",sf_generate,"none", "none", (0,0),(100,100),-100,"0x00000001500410320005a96800006b5300004edc00000d11",
    [],[],"mod_outer_terrain_steppe_a2"),
	("village_70",sf_generate,"none", "none", (0,0),(100,100),-100,"0x00000001500410320005a96800006b5300004edc00000d11",
    [],[],"mod_outer_terrain_steppe_a2"),
	("village_71",sf_generate,"none", "none", (0,0),(100,100),-100,"0x00000001500410320005a96800006b5300004edc00000d11",
    [],[],"mod_outer_terrain_steppe_a2"),
	("village_72",sf_generate,"none", "none", (0,0),(100,100),-100,"0x00000001500410320005a96800006b5300004edc00000d11",
    [],[],"mod_outer_terrain_steppe_a2"),
  ("village_73",sf_generate|sf_muddy_water,"none", "none", (0,0),(240,240),-0.5,"0x00000000200005000008ee3d00007f2800006a9100006095",
    [],[],"mod_outer_terrain_earth_a2"),
	("village_74",sf_generate,"none", "none", (0,0),(100,100),-100,"0x00000001500410320005a96800006b5300004edc00000d11",
    [],[],"mod_outer_terrain_steppe_a2"),
	("village_75",sf_generate,"none", "none", (0,0),(100,100),-100,"0x00000001500410320005a96800006b5300004edc00000d11",
    [],[],"mod_outer_terrain_steppe_a2"),
  ("village_76",sf_generate|sf_muddy_water,"none", "none", (0,0),(240,240),-0.5,"0x00000000200005000008ee3d00007f2800006a9100006095",
    [],[],"mod_outer_terrain_earth_a2"),
	("village_77",sf_generate,"none", "none", (0,0),(100,100),-100,"0x00000001500410320005a96800006b5300004edc00000d11",
    [],[],"mod_outer_terrain_steppe_a2"),
	("village_78",sf_generate,"none", "none", (0,0),(100,100),-100,"0x00000001500410320005a96800006b5300004edc00000d11",
    [],[],"mod_outer_terrain_steppe_a2"),
	("village_79",sf_generate,"none", "none", (0,0),(100,100),-100,"0x00000001500410320005a96800006b5300004edc00000d11",
    [],[],"mod_outer_terrain_steppe_a2"),
	("village_80",sf_generate,"none", "none", (0,0),(100,100),-100,"0x00000001500410320005a96800006b5300004edc00000d11",
    [],[],"mod_outer_terrain_steppe_a2"),
  #################### Yeni koyler ######################
	("village_81",sf_generate,"none", "none", (0,0),(100,100),-100,"0x00000001500410320005a96800006b5300004edc00000d11",
    [],[],"mod_outer_terrain_steppe_a2"),
	("village_82",sf_generate,"none", "none", (0,0),(100,100),-100,"0x00000001500410320005a96800006b5300004edc00000d11",
    [],[],"mod_outer_terrain_steppe_a2"),
	("village_83",sf_generate,"none", "none", (0,0),(100,100),-100,"0x00000001500410320005a96800006b5300004edc00000d11",
    [],[],"mod_outer_terrain_steppe_a2"),
	("village_84",sf_generate,"none", "none", (0,0),(100,100),-100,"0x00000001500410320005a96800006b5300004edc00000d11",
    [],[],"mod_outer_terrain_steppe_a2"),
	("village_85",sf_generate,"none", "none", (0,0),(100,100),-100,"0x00000001500410320005a96800006b5300004edc00000d11",
    [],[],"mod_outer_terrain_steppe_a2"),
	("village_86",sf_generate,"none", "none", (0,0),(100,100),-100,"0x00000001500410320005a96800006b5300004edc00000d11",
    [],[],"mod_outer_terrain_steppe_a2"),
	("village_87",sf_generate,"none", "none", (0,0),(100,100),-100,"0x00000001500410320005a96800006b5300004edc00000d11",
    [],[],"mod_outer_terrain_steppe_a2"),
	("village_88",sf_generate,"none", "none", (0,0),(100,100),-100,"0x00000001500410320005a96800006b5300004edc00000d11",
    [],[],"mod_outer_terrain_steppe_a2"),
	("village_89",sf_generate,"none", "none", (0,0),(100,100),-100,"0x00000001500410320005a96800006b5300004edc00000d11",
    [],[],"mod_outer_terrain_steppe_a2"),
	("village_90",sf_generate,"none", "none", (0,0),(100,100),-100,"0x00000001500410320005a96800006b5300004edc00000d11",
    [],[],"mod_outer_terrain_steppe_a2"),
	
	("village_91",sf_generate,"none", "none", (0,0),(100,100),-100,"0x00000001500410320005a96800006b5300004edc00000d11",
    [],[],"mod_outer_terrain_steppe_a2"),
	
	("village_92",sf_generate,"none", "none", (0,0),(100,100),-100,"0x00000001500410320005a96800006b5300004edc00000d11",
    [],[],"mod_outer_terrain_steppe_a2"),
	
	("village_93",sf_generate,"none", "none", (0,0),(100,100),-100,"0x00000001500410320005a96800006b5300004edc00000d11",
    [],[],"mod_outer_terrain_steppe_a2"),
	
	("village_94",sf_generate|sf_muddy_water,"none", "none", (0,0),(100,100),-100,"0x00000001500410320005a96800006b5300004edc00000d11",
    [],[],"mod_outer_terrain_steppe_a2"),
	
	("village_95",sf_generate,"none", "none", (0,0),(100,100),-100,"0x00000001500410320005a96800006b5300004edc00000d11",
    [],[],"mod_outer_terrain_steppe_a2"),
	
	("village_96",sf_generate,"none", "none", (0,0),(100,100),-100,"0x00000001500410320005a96800006b5300004edc00000d11",
    [],[],"mod_outer_terrain_steppe_a2"),
	
	("village_97",sf_generate,"none", "none", (0,0),(100,100),-100,"0x00000001500410320005a96800006b5300004edc00000d11",
    [],[],"mod_outer_terrain_steppe_a2"),
	
	("village_98",sf_generate,"none", "none", (0,0),(100,100),-100,"0x00000001500410320005a96800006b5300004edc00000d11",
    [],[],"mod_outer_terrain_steppe_a2"),
	
	("village_99",sf_generate,"none", "none", (0,0),(100,100),-100,"0x00000001500410320005a96800006b5300004edc00000d11",
    [],[],"mod_outer_terrain_steppe_a2"),
	
	("village_100",sf_generate,"none", "none", (0,0),(100,100),-100,"0x00000001500410320005a96800006b5300004edc00000d11",
    [],[],"mod_outer_terrain_steppe_a2"),
	
	("village_101",sf_generate,"none", "none", (0,0),(100,100),-100,"0x00000001500410320005a96800006b5300004edc00000d11",
    [],[],"mod_outer_terrain_steppe_a2"),
	
	("village_102",sf_generate,"none", "none", (0,0),(100,100),-100,"0x00000001500410320005a96800006b5300004edc00000d11",
    [],[],"mod_outer_terrain_steppe_a2"),
	
	("village_103",sf_generate,"none", "none", (0,0),(100,100),-100,"0x00000001500410320005a96800006b5300004edc00000d11",
    [],[],"mod_outer_terrain_steppe_a2"),
	
	("village_104",sf_generate,"none", "none", (0,0),(100,100),-100,"0x00000001500410320005a96800006b5300004edc00000d11",
    [],[],"mod_outer_terrain_steppe_a2"),
	
	("village_105",sf_generate,"none", "none", (0,0),(100,100),-100,"0x00000001500410320005a96800006b5300004edc00000d11",
    [],[],"mod_outer_terrain_steppe_a2"),
	
  ("village_106",sf_generate|sf_muddy_water,"none", "none", (0,0),(200,200),-100,"0x000000002000050000059d670000359600004ac200003dcf",
    [],[],"mod_outer_terrain_earth_a2"),
	
  ("village_107",sf_generate|sf_muddy_water,"none", "none", (0,0),(240,240),-0.5,"0x000000002000050000059d670000359600004ac200003dcf",
    [],[],"mod_outer_terrain_earth_a2"),
	
	("village_108",sf_generate,"none", "none", (0,0),(100,100),-100,"0x00000001500410320005a96800006b5300004edc00000d11",
    [],[],"mod_outer_terrain_steppe_a2"),
	
	("village_109",sf_generate,"none", "none", (0,0),(100,100),-100,"0x00000001500410320005a96800006b5300004edc00000d11",
    [],[],"mod_outer_terrain_steppe_a2"),
	
	("village_110",sf_generate,"none", "none", (0,0),(100,100),-100,"0x00000001500410320005a96800006b5300004edc00000d11",
    [],[],"mod_outer_terrain_steppe_a2"),
	
	


	
	
  ("field_1",sf_generate,"none", "none", (0,0),(100,100),-100,"0x000000033a059a5a0009525600002005000060e300001175",
    [],[],"mod_outer_terrain_steppe_a2"),
  ("field_2",sf_generate,"none", "none", (0,0),(100,100),-100,"0x000000033a079a3f000a3a8000006dfd000030a100006522",
    [],[],"mod_outer_terrain_steppe_a2"),
  ("field_3",sf_generate,"none", "none", (0,0),(100,100),-100,"0x30054da28004050000005a76800022aa00002e3b",
    [],[],"mod_outer_terrain_steppe_a2"),
  ("field_4",sf_generate,"none", "none", (0,0),(100,100),-100,"0x30054da28004050000005a76800022aa00002e3b",
    [],[],"mod_outer_terrain_steppe_a2"),
  ("field_5",sf_generate,"none", "none", (0,0),(100,100),-100,"0x30054da28004050000005a76800022aa00002e3b",
    [],[],"mod_outer_terrain_steppe_a2"),

  ("test2",sf_generate,"none", "none", (0,0),(100,100),-100,"0x00000000b0078cb20003fd0000005e480000288c0000286f",
    [],[],"mod_outer_terrain_steppe_a2"),

    ("test3",sf_generate,"none", "none", (0,0),(100,100),-100,"0x00000000b00511d98004b12e0000039f00004e6300005c7d",
    [],[],"mod_outer_terrain_steppe_a2"),

# multiplayer
  ("multi_scene_1",sf_generate,"none", "none", (0,0),(100,100),-100,"0x00000001300389800003a4ea000058340000637a0000399b",
    [],[],"outer_terrain_plain"),
  ("multi_scene_2",sf_generate,"none", "none", (0,0),(100,100),-100,"0x000000012002a0b20004992700006e54000007fe00001fd2",
    [],[],"outer_terrain_steppe"),
  ("multi_scene_3",sf_generate,"none", "none", (0,0),(100,100),-100,"0x000000013002e0b20005154500006e540000235600007b55",
    [],[],"outer_terrain_plain"),
  ("multi_scene_4",sf_generate,"none", "none", (0,0),(100,100),-100,"0x00000001300659630003c8f300003ca000006a8900003c89",
    [],[],"outer_terrain_plain"),
  ("multi_scene_5",sf_generate,"none", "none", (0,0),(100,100),-100,"0x000000023002a1ba0004210900003ca000006a8900007a7b",
    [],[],"outer_terrain_plain"),
  ("multi_scene_6",sf_generate,"none", "none", (0,0),(100,100),-100,"0x00000002300494b200048524000059e80000453300001d32",
    [],[],"outer_terrain_plain"),
  ("multi_scene_7",sf_generate,"none", "none", (0,0),(100,100),-100,"0x0000000130010e0e0005fd84000011c60000285b00005cbe",
    [],[],"outer_terrain_plain"),
  ("multi_scene_8",sf_generate,"none", "none", (0,0),(100,100),-100,"0x0000000020004db18004611400005c918000397b00004c2e",
    [],[],"outer_terrain_plain"),
  ("multi_scene_9",sf_generate,"none", "none", (0,0),(100,100),-100,"0x00000000400032320003c0f300001f9e000011180000031c",   
    [],[],"outer_terrain_snow"),
  ("multi_scene_10",sf_generate,"none", "none", (0,0),(100,100),-100,"0x000000003009cde1000599630000423b00005756000000af",
    [],[],"outer_terrain_plain"),
  ("multi_scene_11",sf_generate,"none", "none", (0,0),(100,100),-100,"0x0000000030015f2b000350d4000011a4000017ee000054af",
    [],[],"outer_terrain_plain"),
  ("multi_scene_12",sf_generate,"none", "none", (0,0),(100,100),-100,"0x000000013003d7e30005053f00003b4e0000146300006e84",
    [],[],"outer_terrain_beach"),
  ("multi_scene_13",sf_generate,"none", "none", (0,0),(100,100),-100,"0x00000001300389800003a4ea000058340000637a0000399b",
    [],[],"outer_terrain_plain"),
  ("multi_scene_14",sf_generate,"none", "none", (0,0),(100,100),-100,"0x0000000040000c910003e8fa0000538900003e9e00005301",
    [],[],"outer_terrain_snow"),
  ("multi_scene_15",sf_generate,"none", "none", (0,0),(100,100),-100,"0x00000000500b1d158005394c00001230800072880000018f",
    [],[],"outer_terrain_desert"),       
  ("multi_scene_16",sf_generate,"none", "none", (0,0),(100,100),-100,"0x00000000d007abd20002c8b1000050c50000752a0000788c",
    [],[],"outer_terrain_desert"),
  ("multi_scene_17",sf_generate,"none", "none", (0,0),(100,100),-100,"0x00000002200005000005f57b00005885000046bd00006d9c",
    [],[],"outer_terrain_plain"),
  ("multi_scene_18",sf_generate|sf_muddy_water,"none", "none", (0,0),(100,100),-100,"0x00000000b00037630002308c00000c9400005d4c00000f3a",
    [],[],"outer_terrain_plain"),
  ("multi_scene_19",sf_generate,"none", "none", (0,0),(100,100),-100,"0x00000001300389800003a4ea000058340000637a0000399b",
    [],[],"outer_terrain_plain"),
  ("multi_scene_20",sf_generate,"none", "none", (0,0),(100,100),-100,"0x000000013002ab630004651800000d7a00007f3100002701",
    [],[],"outer_terrain_plain"),
  
  ("random_multi_plain_medium",sf_generate|sf_randomize|sf_auto_entry_points,"none", "none", (0,0),(240,240),-0.5,"0x00000001394018dd000649920004406900002920000056d7",
    [],[], "outer_terrain_plain"),
  ("random_multi_plain_large",sf_generate|sf_randomize|sf_auto_entry_points,"none", "none", (0,0),(240,240),-0.5,"0x000000013a001853000aa6a40004406900002920001e4f81",
    [],[], "outer_terrain_plain"),
  ("random_multi_steppe_medium", sf_generate|sf_randomize|sf_auto_entry_points, "none", "none", (0,0),(100, 100), -0.5, "0x0000000128601ae300063d8f0004406900002920001e4f81",
    [],[], "outer_terrain_steppe"),
  ("random_multi_steppe_large", sf_generate|sf_randomize|sf_auto_entry_points, "none", "none", (0,0),(100, 100), -0.5, "0x000000012a00d8630009fe7f0004406900002920001e4f81",
    [],[], "outer_terrain_steppe"),

  ("multiplayer_maps_end",sf_generate,"none", "none", (0,0),(100,100),-100,"0x00000001300389800003a4ea000058340000637a0000399b",
    [],[],"outer_terrain_plain"),

  ("wedding",sf_indoors, "castle_h_interior_a", "bo_castle_h_interior_a", (-100,-100),(100,100),-100,"0", [],[]),
  ("lair_steppe_bandits",sf_generate,"none", "none", (0,0),(100,100),-100,"0x00000000200005000005ad68000047de0000055800004881",
    [],[],"mod_outer_terrain_earth_a2"), #a box canyon with a spring? -tents...
  ("lair_taiga_bandits",sf_generate,"none", "none", (0,0),(100,100),-100,"0x00000000200005000005ad68000047de0000055800004881",
    [],[],"mod_outer_terrain_earth_a2"), #an encampment in the woods
  ("lair_desert_bandits",sf_generate,"none", "none", (0,0),(100,100),-100,"0x00000000200005000005ad68000047de0000055800004881",
    [],[],"mod_outer_terrain_earth_a2"), #an encampment in the woods
  ("lair_forest_bandits",sf_generate,"none", "none", (0,0),(100,100),-100,"0x00000000200005000005ad68000047de0000055800004881",
    [],[],"mod_outer_terrain_earth_a2"), #an encampment in the woods
  ("lair_mountain_bandits",sf_generate,"none", "none", (0,0),(100,100),-100,"0x00000000200005000005ad68000047de0000055800004881",
    [],[],"mod_outer_terrain_earth_a2"),
  ("lair_sea_raiders",sf_generate|sf_muddy_water, "none", "none", (0, 0), (120, 120), 0, "0x00000000500005000005ea05000000000000000000000000",
    [],[],"mod_outer_terrain_coast_a_r1"), #the longships beached on a hidden cove

  ("quick_battle_scene_1",sf_generate, "none", "none", (0, 0), (120, 120), -100, "0x0000000050000500000649920000556d0000323c00003a1d", 
    [],[], "mod_outer_terrain_forest_a2"),
  ("quick_battle_scene_2",sf_generate|sf_muddy_water, "none", "none", (0, 0), (120, 120), -100, "0x000000023002dee300045d1d000001bf0000299a0000638f", 
    [],[], "mod_outer_terrain_forest_a2"),
  ("quick_battle_scene_3",sf_generate, "none", "none", (0, 0), (240, 240), -0.5, "0x0000000550000500000bb2ea0004406900002920001e4f81", 
    [],[], "mod_outer_terrain_forest_a2"),
  ("quick_battle_scene_4",sf_generate,"none", "none", (0,0),(100,100),-100,"0x0000000020000500000721e6000011ab000063ff000007ad", 
    [],[], "mod_outer_terrain_earth_a2"),
  ("quick_battle_scene_5",sf_generate,"none", "none", (0,0),(100,100),-100,"0x00000000200005000005b94200002a27000031a1000044aa",
    [],[],"mod_outer_terrain_earth_a2"),
  ("quick_battle_maps_end",sf_generate,"none", "none", (0,0),(100,100),-100,"0x00000001300389800003a4ea000058340000637a0000399b",
    [],[],"outer_terrain_desert_rocky"),

  ("tutorial_training_ground",sf_generate,"none", "none", (0,0),(120,120),-100,"0x000000003000050000046d1b0000189f00002a8380006d91",
    [],[], "mod_outer_terrain_steppe_a2"),
    
 # ("town_1_room",sf_indoors,"viking_interior_tavern_a", "bo_viking_interior_tavern_a", (-100,-100),(100,100),-100,"0",
 #   [],[]),
 # ("town_5_room",sf_indoors, "interior_town_house_d", "bo_interior_town_house_d", (-100,-100),(100,100),-100,"0",
  #  ["exit"],[]),
 # ("town_6_room",sf_indoors, "interior_town_house_j", "bo_interior_town_house_j", (-100,-100),(100,100),-100,"0",
  #  ["exit"],[]),
 # ("town_8_room",sf_indoors, "interior_house_b", "bo_interior_house_b", (-100,-100),(100,100),-100,"0",
  #  ["exit"],[]),
 # ("town_10_room",sf_indoors, "interior_town_house_steppe_c", "bo_interior_town_house_steppe_c", (-100,-100),(100,100),-100,"0",
  #  ["exit"],[]),
 # ("town_19_room",sf_indoors, "interior_town_house_steppe_d", "bo_interior_town_house_steppe_d", (-100,-100),(100,100),-100,"0",
  #  ["exit"],[]),

  ("town_1_room",sf_indoors, "interior_town_house_j", "bo_interior_town_house_j", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("town_5_room",sf_indoors, "interior_town_house_j", "bo_interior_town_house_j", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("town_6_room",sf_indoors, "interior_town_house_j", "bo_interior_town_house_j", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("town_8_room",sf_indoors, "interior_town_house_j", "bo_interior_town_house_j", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),
  ("town_10_room",sf_indoors, "interior_town_house_j", "bo_interior_town_house_j", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),

  ("town_19_room",sf_indoors, "interior_town_house_steppe_d", "bo_interior_town_house_steppe_d", (-100,-100),(100,100),-100,"0",
    ["exit"],[]),

  ("meeting_scene_steppe",0,"ch_meet_desert_a", "bo_encounter_spot", (-40,-40),(40,40),-100,"0",
    [],[]),
  ("meeting_scene_plain",0,"ch_meet_desert_a", "bo_encounter_spot", (-40,-40),(40,40),-100,"0",
    [],[]),
  ("meeting_scene_snow",0,"ch_meet_desert_a", "bo_encounter_spot", (-40,-40),(40,40),-100,"0",
    [],[]),
  ("meeting_scene_desert",0,"ch_meet_desert_a", "bo_encounter_spot", (-40,-40),(40,40),-100,"0",
    [],[]),
  ("meeting_scene_steppe_forest",0,"ch_meet_desert_a", "bo_encounter_spot", (-40,-40),(40,40),-100,"0",
    [],[]),
  ("meeting_scene_plain_forest",0,"ch_meet_desert_a", "bo_encounter_spot", (-40,-40),(40,40),-100,"0",
    [],[]),
  ("meeting_scene_snow_forest",0,"ch_meet_desert_a", "bo_encounter_spot", (-40,-40),(40,40),-100,"0",
    [],[]),
  ("meeting_scene_desert_forest",0,"ch_meet_desert_a", "bo_encounter_spot", (-40,-40),(40,40),-100,"0",
    [],[]),

  ("enterprise_tannery",sf_generate,"ch_meet_desert_a", "bo_encounter_spot", (-40,-40),(40,40),-100,"0x000000012004480500040902000041cb00005ae800000ff5",
    [],[]),
  ("enterprise_winery",sf_indoors,"winery_interior", "bo_winery_interior", (-40,-40),(40,40),-100,"0",
    [],[]),
  ("enterprise_mill",sf_indoors,"mill_interior", "bo_mill_interior", (-40,-40),(40,40),-100,"0",
    [],[]),
  ("enterprise_smithy",sf_indoors,"smithy_interior", "bo_smithy_interior", (-40,-40),(40,40),-100,"0",
    [],[]),
  ("enterprise_dyeworks",sf_indoors,"weavery_interior", "bo_weavery_interior", (-40,-40),(40,40),-100,"0",
    [],[]),
  ("enterprise_linen_weavery",sf_indoors,"weavery_interior", "bo_weavery_interior", (-40,-40),(40,40),-100,"0",
    [],[]),
  ("enterprise_wool_weavery",sf_indoors,"weavery_interior", "bo_weavery_interior", (-40,-40),(40,40),-100,"0",
    [],[]),
  ("enterprise_brewery",sf_indoors,"brewery_interior", "bo_brewery_interior", (-40,-40),(40,40),-100,"0",
    [],[]),
  ("enterprise_oil_press",sf_indoors,"oil_press_interior", "bo_oil_press_interior", (-40,-40),(40,40),-100,"0",
    [],[]),



# Arch3r Bridge Battle begin
  ("bridge_1",sf_generate|sf_muddy_water, "none", "none", (0, 0), (90, 90), 0, "0x00000002500005000005d176000076f50000729d000013cf",
    [],[], "mod_outer_terrain_forest_a2"),
  ("bridge_2",sf_generate|sf_muddy_water, "none", "none", (0, 0), (90, 90), 0, "0x00000002500005000005d176000076f50000729d000013cf",
    [],[], "mod_outer_terrain_forest_a2"),
  ("bridge_3",sf_generate|sf_muddy_water, "none", "none", (0, 0), (90, 90), 0, "0x00000002500005000005d176000076f50000729d000013cf",
    [],[], "mod_outer_terrain_forest_a2"),
  ("bridge_4",sf_generate|sf_muddy_water, "none", "none", (0, 0), (90, 90), 0, "0x00000002500005000005d176000076f50000729d000013cf",
    [],[], "mod_outer_terrain_forest_a2"),
  ("bridge_5",sf_generate|sf_muddy_water, "none", "none", (0, 0), (90, 90), 0, "0x00000002500005000005d176000076f50000729d000013cf",
    [],[], "mod_outer_terrain_forest_a2"),
  ("bridge_6",sf_generate|sf_muddy_water, "none", "none", (0, 0), (90, 90), 0, "0x00000002500005000005d176000076f50000729d000013cf",
    [],[], "mod_outer_terrain_forest_a2"),
  ("bridge_7",sf_generate|sf_muddy_water, "none", "none", (0, 0), (90, 90), 0, "0x00000002500005000005d176000076f50000729d000013cf",
    [],[], "mod_outer_terrain_forest_a2"),
  ("bridge_8",sf_generate|sf_muddy_water, "none", "none", (0, 0), (90, 90), 0, "0x00000002500005000005d176000076f50000729d000013cf",
    [],[], "mod_outer_terrain_forest_a2"),
  ("bridge_9",sf_generate|sf_muddy_water, "none", "none", (0, 0), (90, 90), 0, "0x00000002500005000005d176000076f50000729d000013cf",
    [],[], "mod_outer_terrain_forest_a2"),
  ("bridge_10",sf_generate|sf_muddy_water, "none", "none", (0, 0), (90, 90), 0, "0x00000002500005000005d176000076f50000729d000013cf",
    [],[], "mod_outer_terrain_forest_a2"),
  ("bridge_11",sf_generate|sf_muddy_water, "none", "none", (0, 0), (90, 90), 0, "0x00000002500005000005d176000076f50000729d000013cf",
    [],[], "mod_outer_terrain_forest_a2"),
  ("bridge_12",sf_generate|sf_muddy_water, "none", "none", (0, 0), (90, 90), 0, "0x00000002500005000005d176000076f50000729d000013cf",
    [],[], "mod_outer_terrain_forest_a2"),
  ("bridge_13",sf_generate|sf_muddy_water, "none", "none", (0, 0), (90, 90), 0, "0x00000002500005000005d176000076f50000729d000013cf",
    [],[], "mod_outer_terrain_forest_a2"),
  ("bridge_14",sf_generate|sf_muddy_water, "none", "none", (0, 0), (90, 90), 0, "0x00000002500005000005d176000076f50000729d000013cf",
    [],[], "mod_outer_terrain_forest_a2"),
#  ("bridge_15",sf_generate,"none", "none", (0,0),(120,120),-100,"0x3a078bb2000589630000667200002fb90000179c",
#    [],[], "outer_terrain_plain"),
# Arch3r Bridge Battle end

#-## Outposts begin
  ("outpost_one_one_steppe",sf_generate,"none", "none", (0,0),(100,100),-100,"0x000000002c678e1e8003f0ff107a3fff00004b7700007d87",
    [],[],"mod_outer_terrain_earth_a2"),
  ("outpost_one_one_plain",sf_generate,"none", "none", (0,0),(100,100),-100,"0x000000003009cde1000599630000423b00005756000000af",
    [],[],"mod_outer_terrain_earth_a2"),
  ("outpost_one_one_snow",sf_generate,"none", "none", (0,0),(100,100),-100,"0x000000004c678e240003f0ff107a3fff08cbd53700007d87",
    [],[],"mod_outer_terrain_earth_a2"),
  ("outpost_one_one_desert",sf_generate,"none", "none", (0,0),(100,100),-100,"0x0000000055878e1ec003f0ff0000445800002b7500007d87",
    [],[],"mod_outer_terrain_earth_a2"),
  ("outpost_one_one_steppe_forest",sf_generate,"none", "none", (0,0),(100,100),-100,"0x00000000ac678e1e8003f0ff107a3fff00004b7700007d87",
    [],[],"mod_outer_terrain_earth_a2"),
  ("outpost_one_one_forest",sf_generate,"none", "none", (0,0),(100,100),-100,"0x00000000bc678e248003f0ff107a3fff08cbd53700007d87",
    [],[],"mod_outer_terrain_earth_a2"),
  ("outpost_one_one_snow_forest",sf_generate,"none", "none", (0,0),(100,100),-100,"0x00000000cc678e1e8003f0ff107a3fff0043c9af00007d87",
    [],[],"mod_outer_terrain_earth_a2"),
  ("outpost_one_one_desert_forest",sf_generate,"none", "none", (0,0),(100,100),-100,"0x00000000dc678e240003f0ff107a3fff08cbd537000068de",
    [],[],"mod_outer_terrain_earth_a2"),

  ("outpost_one_two_steppe",sf_generate,"none", "none", (0,0),(100,100),-100,"0x000000002c678e1e8003f0ff107a3fff00004b7700007d87",
    [],[],"mod_outer_terrain_earth_a2"),
  ("outpost_one_two_plain",sf_generate,"none", "none", (0,0),(100,100),-100,"0x000000003009cde1000599630000423b00005756000000af",
    [],[],"mod_outer_terrain_earth_a2"),
  ("outpost_one_two_snow",sf_generate,"none", "none", (0,0),(100,100),-100,"0x00000000400032320003c0f300001f9e000011180000031c",
    [],[],"mod_outer_terrain_earth_a2"),
  ("outpost_one_two_desert",sf_generate,"none", "none", (0,0),(100,100),-100,"0x0000000055878e1ec003f0ff0000445800002b7500007d87",
    [],[],"mod_outer_terrain_earth_a2"),
  ("outpost_one_two_steppe_forest",sf_generate,"none", "none", (0,0),(100,100),-100,"0x00000000ac678e1e8003f0ff107a3fff00004b7700007d87",
    [],[],"mod_outer_terrain_earth_a2"),
  ("outpost_one_two_forest",sf_generate,"none", "none", (0,0),(100,100),-100,"0x00000000bc678e248003f0ff107a3fff08cbd53700007d87",
    [],[],"mod_outer_terrain_earth_a2"),
  ("outpost_one_two_snow_forest",sf_generate,"none", "none", (0,0),(100,100),-100,"0x0000000040000c910003e8fa0000538900003e9e00005301",
    [],[],"mod_outer_terrain_earth_a2"),
  ("outpost_one_two_desert_forest",sf_generate,"none", "none", (0,0),(100,100),-100,"0x00000000dc678e240003f0ff107a3fff08cbd537000068de",
    [],[],"mod_outer_terrain_earth_a2"),
	
  ("outpost_two_one_steppe",sf_generate,"none", "none", (0,0),(100,100),-100,"0x000000002c678e1e8003f0ff107a3fff00004b7700007d87",
    [],[],"mod_outer_terrain_earth_a2"),
  ("outpost_two_one_plain",sf_generate,"none", "none", (0,0),(100,100),-100,"0x30054da28004050000005a76800022aa00002e3b",
    [],[],"mod_outer_terrain_earth_a2"),
  ("outpost_two_one_snow",sf_generate,"none", "none", (0,0),(100,100),-100,"0x000000004c678e240003f0ff107a3fff08cbd53700007d87",
    [],[],"mod_outer_terrain_earth_a2"),
  ("outpost_two_one_desert",sf_generate,"none", "none", (0,0),(100,100),-100,"0x000000005c678e240003f0ff107a3fff08cbd53700007d87",
    [],[],"mod_outer_terrain_earth_a2"),
  ("outpost_two_one_steppe_forest",sf_generate,"none", "none", (0,0),(100,100),-100,"0x00000000ac678e1e8003f0ff107a3fff00004b7700007d87",
    [],[],"mod_outer_terrain_earth_a2"),
  ("outpost_two_one_forest",sf_generate,"none", "none", (0,0),(100,100),-100,"0x00000000bc678e248003f0ff107a3fff08cbd53700007d87",
    [],[],"mod_outer_terrain_earth_a2"),
  ("outpost_two_one_snow_forest",sf_generate,"none", "none", (0,0),(100,100),-100,"0x00000000cc678e1e8003f0ff107a3fff0043c9af00007d87",
    [],[],"mod_outer_terrain_earth_a2"),
  ("outpost_two_one_desert_forest",sf_generate,"none", "none", (0,0),(100,100),-100,"0x00000000dc678e240003f0ff107a3fff08cbd537000068de",
    [],[],"mod_outer_terrain_earth_a2"),
	
  ("outpost_two_two_steppe",sf_generate,"none", "none", (0,0),(100,100),-100,"0x000000002c678e1e8003f0ff107a3fff00004b7700007d87",
    [],[],"mod_outer_terrain_earth_a2"),
  ("outpost_two_two_plain",sf_generate,"none", "none", (0,0),(100,100),-100,"0x000000003009cde1000599630000423b00005756000000af",
    [],[],"mod_outer_terrain_earth_a2"),
  ("outpost_two_two_snow",sf_generate,"none", "none", (0,0),(100,100),-100,"0x00000000400032320003c0f300001f9e000011180000031c",
    [],[],"mod_outer_terrain_earth_a2"),
  ("outpost_two_two_desert",sf_generate,"none", "none", (0,0),(100,100),-100,"0x000000005c678e240003f0ff107a3fff08cbd53700007d87",
    [],[],"mod_outer_terrain_earth_a2"),
  ("outpost_two_two_steppe_forest",sf_generate,"none", "none", (0,0),(100,100),-100,"0x00000000ac678e1e8003f0ff107a3fff00004b7700007d87",
    [],[],"mod_outer_terrain_earth_a2"),
  ("outpost_two_two_forest",sf_generate,"none", "none", (0,0),(100,100),-100,"0x00000000bc678e248003f0ff107a3fff08cbd53700007d87",
    [],[],"mod_outer_terrain_earth_a2"),
  ("outpost_two_two_snow_forest",sf_generate,"none", "none", (0,0),(100,100),-100,"0x0000000040000c910003e8fa0000538900003e9e00005301",
    [],[],"mod_outer_terrain_earth_a2"),
  ("outpost_two_two_desert_forest",sf_generate,"none", "none", (0,0),(100,100),-100,"0x00000000dc678e240003f0ff107a3fff08cbd537000068de",
    [],[],"mod_outer_terrain_earth_a2"),
	
  ("fort",sf_generate,"none", "none", (0,0),(100,100),-100, "0x000000003224dfb20004a92f00001d760000611000005679",
    [],[],"mod_outer_terrain_earth_a2"),
  ("fort_plain",sf_generate,"none", "none", (0,0),(100,100),-100, "0x00000001300389800003a4ea000058340000637a0000399b",
    [],[],"mod_outer_terrain_earth_a2"),
  ("fort_snow",sf_generate,"none", "none", (0,0),(100,100),-100, "0x00000000b00037630002308c00000c9400005d4c00000f3a",
    [],[],"mod_outer_terrain_earth_a2"),
  ("fort_forest",sf_generate,"none", "none", (0,0),(100,100),-100, "0x000000003224dfb20004a92f00001d760000611000005679",
    [],[],"mod_outer_terrain_earth_a2"),
#-## Outposts end




#TEMPERED ENTRENCHED CAMP
("entrenched_steppe",sf_generate,"none","none",(0,0),(450,450),-0.5	,"0x0000000421220f00400d2348000064170000197b00002ad3"	,[],[],"mod_outer_terrain_steppe_a2"),
("entrenched_plain",sf_generate,"none","none",(0,0),(450,450),-0.5	,"0x000000043464c8d1400d23480000065100007b430000254d"	,[],[],"mod_outer_terrain_steppe_a2"),
("entrenched_snow",sf_generate,"none","none",(0,0),(450,450),-0.5	,"0x0000000042448e00000d2348000063bb000076e200002307"	,[],[],"mod_outer_terrain_steppe_a2"),
("entrenched_desert",sf_generate,"none","none",(0,0),(450,450),-0.5	,"0x000000045002ca80000a9eae0000310200002bc000001ed5"	,[],[],"mod_outer_terrain_steppe_a2"),
("entrenched_steppe_forest",sf_generate,"none","none",(0,0),(450,450),-0.5	,"0x00000000a7218a95000d234800003de1000034650000243b"	,[],[],"mod_outer_terrain_steppe_a2"),
("entrenched_plain_forest",sf_generate,"none","none",(0,0),(200,200),-0.5	,"0x00000000b8e79732000d234800004b1500004628000064e5"	,[],[],"mod_outer_terrain_steppe_a2"),
("entrenched_snow_forest",sf_generate,"none","none",(0,0),(450,450),-0.5	,"0x00000000ca0511b1000d234800003f82000065a500007fc9"	,[],[],"mod_outer_terrain_steppe_a2"),
("entrenched_desert_forest",sf_generate	,"none","none",(0,0),(450,450),-0.5	,"0x00000004da02cb320009c2730000614c000069a4000033f6"	,[],[],"mod_outer_terrain_steppe_a2"),
#tempered normal camp 	
("not_entrenched_steppe",sf_generate,"none","none",(0,0),(450,450),-0.5	,"0x0000000421220f00400d2348000064170000197b00002ad3"	,[],[],"mod_outer_terrain_steppe_a2"),
("not_entrenched_plain",sf_generate,"none","none",(0,0),(450,450),-0.5	,"0x000000043464c8d1400d23480000065100007b430000254d"	,[],[],"mod_outer_terrain_steppe_a2"),
("not_entrenched_snow",sf_generate,"none","none",(0,0),(450,450),-0.5	,"0x0000000042448e00000d2348000063bb000076e200002307"	,[],[],"mod_outer_terrain_steppe_a2"),
("not_entrenched_desert",sf_generate,"none","none",(0,0),(450,450),-0.5	,"0x000000045002ca80000a9eae0000310200002bc000001ed5"	,[],[],"mod_outer_terrain_steppe_a2"),
("not_entrenched_steppe_forest",sf_generate,"none","none",(0,0),(450,450),-0.5	,"0x00000000a7218a95000d234800003de1000034650000243b"	,[],[],"mod_outer_terrain_steppe_a2"),
("not_entrenched_plain_forest",sf_generate,"none","none",(0,0),(200,200),-0.5	,"0x00000000b8e79732000d234800004b1500004628000064e5"	,[],[],"mod_outer_terrain_steppe_a2"),
("not_entrenched_snow_forest",sf_generate,"none","none",(0,0),(450,450),-0.5	,"0x00000000ca0511b1000d234800003f82000065a500007fc9"	,[],[],"mod_outer_terrain_steppe_a2"),
("not_entrenched_desert_forest"	,sf_generate,"none","none",(0,0),(450,450),-0.5	,"0x000000045002ca80000a9eae0000310200002bc000001ed5"	,[],[],"mod_outer_terrain_steppe_a2"),
#TEMPERED entrenchment remastered begins
("camp_steppe",sf_generate,"none","none",(0,0),(450,450),-0.5	,"0x0000000020018807000d234800001c0d00006c30000076b9"	,[],[],"mod_outer_terrain_steppe_a2"),
("camp_plain",sf_generate,"none","none",(0,0),(450,450),-0.5	,"0x0000000030018807000d234800001c0d00006c3000002e42"	,[],[],"mod_outer_terrain_steppe_a2"),
("camp_snow",sf_generate,"none","none",(0,0),(450,450),-0.5	,"0x0000000040010889000d234800005cc50000262a00003686"	,[],[],"mod_outer_terrain_steppe_a2"),
("camp_desert",sf_generate,"none","none",(0,0),(450,450),-0.5	,"0x000000005a030b16000d23480000037d00004bf2000073c3"	,[],[],"mod_outer_terrain_steppe_a2"),
("camp_steppe_forest",sf_generate,"none","none",(0,0),(450,450),-0.5	,"0x00000000a0060822000d234800001abc00007cbb00001a1c"	,[],[],"mod_outer_terrain_steppe_a2"),
("camp_plain_forest",sf_generate,"none","none",(0,0),(200,200),-0.5	,"0x00000000b0c78a83000d234800003aca0000432f0000226d"	,[],[],"mod_outer_terrain_steppe_a2"),
("camp_snow_forest",sf_generate,"none","none",(0,0),(450,450),-0.5	,"0x00000000c206cb10000d23480000355100002c360000370d"	,[],[],"mod_outer_terrain_steppe_a2"),
("camp_desert_forest",sf_generate,"none","none",(0,0),(450,450),-0.5	,"0x000000005a030b16000d23480000037d00004bf2000073c3"	,[],[],"mod_outer_terrain_steppe_a2"),
#Tempered entrenchment remastered ends	

#Wulf begin Tocan
#("sea_1",sf_generate,"none", "none", (0,0),(240,240),-0.5,"0x0000000030000000c00d2348000000008000000000000000",
#[],[]),
#("sea_4",sf_generate,"none", "none", (0,0),(240,240),-0.5,"0x0000000030000000c00d2348000000008000000000000000",
#[],[]),
#("sea_2",sf_generate,"none", "none", (0,0),(240,240),-0.5,"0x0000000030000000c00d2348000000008000000000000000",
#[],[]),
#Wulf end Tocan

#Hispania 1200, viaje maritimo
("meeting_scene_water",sf_generate|sf_muddy_water|sf_no_horses,"none", "none", (0,0),(240,240),-0.5,"0x00000000200005000002a8ac000003fe0000430c000011bb",
[],[],"outer_terrain_playa"),
#Hispania 1200, conversacion interior
("meeting_scene_village_c",sf_generate,"none", "none", (0,0),(200,200),-100,"0x00000000300005000002308c000079dc000052f100002b71",
[],[]),
("meeting_scene_village_m",sf_generate,"none", "none", (0,0),(240,240),-0.5,"0x00000000300005000002308c000079dc000052f100002b71",
[],[]),

#("mod_scene_bridge_1", sf_generate, "none", "none", (0, 0), (90, 90), 0, "0x00000002500005000005d176000076f50000729d000013cf",[], [], "mod_outer_terrain_desert_a"),
#("mod_scene_bridge_2", sf_generate|sf_auto_entry_points, "none", "none", (0, 0), (240, 240), -0.5, "0x000000025c600500000691a400006c0e000057b800005f09",[], [], "mod_outer_terrain_desert_a"),
#("mod_scene_bridge_3", sf_generate|sf_auto_entry_points, "none", "none", (0, 0), (240, 240), -0.5, "0x000000025c600500000691a400006c0e000057b800005f09",[], [], "mod_outer_terrain_desert_a"),
#("mod_scene_bridge_4", sf_generate|sf_auto_entry_points, "none", "none", (0, 0), (240, 240), -0.5, "0x000000025c600500000691a400006c0e000057b800005f09",[], [], "mod_outer_terrain_desert_a"),
#("mod_scene_bridge_5", sf_generate|sf_auto_entry_points, "none", "none", (0, 0), (240, 240), -0.5, "0x000000025c600500000691a400006c0e000057b800005f09",[], [], "mod_outer_terrain_desert_a"),
#("mod_scene_bridge_7", sf_generate|sf_auto_entry_points, "none", "none", (0, 0), (240, 240), -0.5, "0x000000025c600500000691a400006c0e000057b800005f09",[], [], "mod_outer_terrain_desert_a"),
#("mod_scene_bridge_8", sf_generate|sf_auto_entry_points, "none", "none", (0, 0), (240, 240), -0.5, "0x000000025c600500000691a400006c0e000057b800005f09",[], [], "mod_outer_terrain_desert_a"),
#("mod_scene_bridge_9", sf_generate|sf_auto_entry_points, "none", "none", (0, 0), (240, 240), -0.5, "0x000000025c600500000691a400006c0e000057b800005f09",[], [], "mod_outer_terrain_desert_a"),
#("mod_scene_bridge_11", sf_generate, "none", "none", (0, 0), (90, 90), 0, "0x000000005000050000058d65000038d700004963000054ec",[], [], "mod_outer_terrain_desert_a"),
("mod_scene_bridge_12", sf_generate|sf_muddy_water, "none", "none", (0, 0), (90, 90), 0, "0x00000002500005000005d176000076f50000729d000013cf",[], [], "mod_outer_terrain_forest_a2"),
#("mod_scene_bridge_13", sf_generate, "none", "none", (0, 0), (90, 90), 0, "0x00000002500005000005d176000076f50000729d000013cf",[], [], "mod_outer_terrain_desert_a"),
#("mod_scene_bridge_14", sf_generate, "none", "none", (0, 0), (120, 120), -0.5, "0x000000023002dee300045d1d000001bf0000299a0000638f",[], [], "mod_outer_terrain_desert_a"),
#("mod_random_scene_river_begin", sf_generate|sf_auto_entry_points, "none", "none", (0, 0), (240, 240), -0.5, "0x000000025c600500000691a400006c0e000057b800005f09",[], [], "mod_outer_terrain_desert_a"),
#("mod_random_river_1", sf_generate|sf_auto_entry_points, "none", "none", (0, 0), (240, 240), -0.5, "0x000000025c600500000691a400006c0e000057b800005f09",[], [], "mod_outer_terrain_steppe_forest_big"),
#("mod_random_scene_river_end", sf_generate|sf_auto_entry_points, "none", "none", (0, 0), (240, 240), -0.5, "0x0000000051200500000d234700002d3e000063bf000001c5",[], [], "mod_outer_terrain_desert_a"),
("mod_random_scene_desert_begin", sf_generate, "none", "none", (0, 0), (240, 240), 0, "0x0000000151400532000a729c0000b1070000292000007ff7",[], [], "mod_outer_terrain_steppe_a2"),
("mod_sa_random_desert_1", sf_generate, "none", "none", (0, 0), (240, 240), 0, "0x0000000151400532000aa6a4000440690000292000007ff7",[], [], "mod_outer_terrain_steppe_a2"),
("mod_random_scene_desert_end", sf_generate, "none", "none", (0, 0), (240, 240), 0, "0x0000000151400532000a729c0000b1070000292000007ff7",[], [], "mod_outer_terrain_steppe_a2"),
("mod_random_scene_desert_forest_begin", sf_generate, "none", "none", (0, 0), (120, 120), 0, "0x00000002500005000005d176000076f50000729d000013cf",[], [], "mod_outer_terrain_forest_a2"),
("mod_random_desert_forest_2", sf_generate, "none", "none", (0, 0), (120, 120), 0, "0x0000000050000500000649920000556d0000323c00003a1d",[], [], "mod_outer_terrain_forest_a2"),
#("mod_random_desert_forest_3", sf_generate, "none", "none", (0, 0), (240, 240), 0, "0x0000000550000500000bb2ea0004406900002920001e4f81",[], [], "mod_outer_terrain_desert_a"),
("mod_random_desert_forest_4", sf_generate, "none", "none", (0, 0), (120, 120), 0, "0x000000005000050000058d65000038d700004963000054ec",[], [], "mod_outer_terrain_forest_a2"),
("mod_random_desert_forest_5", sf_generate, "none", "none", (0, 0), (120, 120), 0, "0x00000002500005000005d176000076f50000729d000013cf",[], [], "mod_outer_terrain_forest_a2"),
("mod_random_desert_forest_6", sf_generate, "none", "none", (0, 0), (120, 120), 0, "0x0000000050000500000649920000556d0000323c00003a1d",[], [], "mod_outer_terrain_forest_a2"),
("mod_random_desert_forest_7", sf_generate, "none", "none", (0, 0), (90, 90), 0, "0x00000002500005000005d176000076f50000729d000013cf",[], [], "mod_outer_terrain_forest_a2"),
("mod_random_desert_forest_8", sf_generate, "none", "none", (0, 0), (90, 90), 0, "0x00000002500005000005d176000076f50000729d000013cf",[], [], "mod_outer_terrain_forest_a2"),
("mod_random_desert_forest_9", sf_generate, "none", "none", (0, 0), (90, 90), 0, "0x00000002500005000005d176000076f50000729d000013cf",[], [], "mod_outer_terrain_forest_a2"),
#("mod_random_desert_forest_10", sf_generate, "none", "none", (0, 0), (240, 240), 0, "0x000000025c600500000691a400006c0e000057b800005f09",[], [], "mod_outer_terrain_desert_a"),
("mod_random_desert_forest_11", sf_generate, "none", "none", (0, 0), (90, 90), 0, "0x00000002500005000005d176000076f50000729d000013cf",[], [], "mod_outer_terrain_forest_a2"),
("mod_random_desert_forest_12", sf_generate, "none", "none", (0, 0), (120, 120), -100, "0x0000000040400500000d234800003a270000394b00000bd0",[], [], "mod_outer_terrain_forest_a2"),
("mod_random_desert_forest_13", sf_generate, "none", "none", (0, 0), (100, 100), -100, "0x0000000040400500000d234800003a270000394b00000bd0",[], [], "mod_outer_terrain_forest_a2"),
("mod_random_scene_desert_forest_end", sf_generate|sf_auto_entry_points, "none", "none", (0, 0), (240, 240), 0, "0x00000002500005000005d176000076f50000729d000013cf",[], [], "mod_outer_terrain_forest_a2"),
#("mod_random_scene_plain_begin", sf_generate|sf_auto_entry_points, "none", "none", (0, 0), (240, 240), -100, "0x0000000131400532000a729c0000b1070000292000007ff7",[], [], "mod_outer_terrain_plain_a_2"),
#("mod_random_plain_1", sf_generate|sf_auto_entry_points, "none", "none", (0, 0), (240, 240), -100, "0x0000000131400532000a729c0000b1070000292000007ff7",[], [], "mod_outer_terrain_plain_a_2"),
#("mod_random_scene_plain_end", sf_generate|sf_auto_entry_points, "none", "none", (0, 0), (240, 240), -100, "0x0000000131400532000a729c0000b1070000292000007ff7",[], [], "mod_outer_terrain_plain_a_2"),
#("mod_random_scene_steppe_begin", sf_generate|sf_auto_entry_points, "none", "none", (0, 0), (240, 240), -100, "0x0000000121400532000a729c0000b1070000292000007ff7",[], [], "mod_outer_terrain_plain_a_2"),
#("mod_random_steppe_1", sf_generate|sf_auto_entry_points, "none", "none", (0, 0), (240, 240), -100, "0x0000000121400532000a729c0000b1070000292000007ff7",[], [], "mod_outer_terrain_plain_a_2"),
#("mod_random_scene_steppe_end", sf_generate|sf_auto_entry_points, "none", "none", (0, 0), (240, 240), -100, "0x0000000121400532000a729c0000b1070000292000007ff7",[], [], "mod_outer_terrain_plain_a_2"),
#("mod_random_scene_plain_forest_begin", sf_generate|sf_auto_entry_points, "none", "none", (0, 0), (240, 240), -0.5, "0x0000000230000500000691a400006c0e000057b800005f09",[], [], "mod_outer_terrain_desert_a"),
#("mod_random_plain_forest_1", sf_generate|sf_auto_entry_points, "none", "none", (0, 0), (240, 240), -0.5, "0x0000000230000500000691a400006c0e000057b800005f09",[], [], "mod_outer_terrain_desert_a"),
#("mod_random_plain_forest_2", sf_generate|sf_auto_entry_points, "none", "none", (0, 0), (240, 240), -0.5, "0x0000000230000500000691a400006c0e000057b800005f09",[], [], "mod_outer_terrain_desert_a"),
#("mod_random_scene_plain_forest_end", sf_generate|sf_auto_entry_points, "none", "none", (0, 0), (240, 240), -0.5, "0x0000000230000500000691a400006c0e000057b800005f09",[], [], "mod_outer_terrain_desert_a"),
("mod_random_scene_desert_coast_begin", sf_generate|sf_muddy_water, "none", "none", (0, 0), (120, 120), -100, "0x00000000500005000005ea05000000000000000000000000",[], [], "mod_outer_terrain_coast_a_r1"),
("mod_random_desert_coast_2", sf_generate|sf_muddy_water, "none", "none", (0, 0), (120, 120), 0, "0x00000000500005000005ea05000000000000000000000000",[], [], "mod_outer_terrain_coast_a_r1"),
("mod_random_scene_desert_coast_end", sf_generate|sf_muddy_water, "none", "none", (0, 0), (120, 120), -100, "0x00000000500005000005ea05000000000000000000000000",[], [], "mod_outer_terrain_coast_a_r1"),

]
# modmerger_start version=201 type=2
try:
    component_name = "scenes"
    var_set = { "scenes" : scenes }
    from modmerger import modmerge
    modmerge(var_set)
except:
    raise
# modmerger_end
